/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.io.IOException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.QuickNioServer;

public class CompletionAcceptHandler
implements CompletionHandler<ServerSocketChannel, QuickNioServer> {
    public static void registerChannel(Selector selector, SelectableChannel channel, int ops) {
        try {
            if (channel == null) {
                return;
            }
            channel.configureBlocking(false);
            channel.register(selector, ops);
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    @Override
    public void completed(ServerSocketChannel serverSocketChannel, QuickNioServer quickNioServer) {
        SocketChannel socketChannel;
        try {
            socketChannel = serverSocketChannel.accept();
            Logger.debug((String)"Client [{}] accepted.", (Object[])new Object[]{socketChannel.getRemoteAddress()});
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        CompletionAcceptHandler.registerChannel(quickNioServer.getSelector(), socketChannel, 1);
    }

    @Override
    public void failed(Throwable exc, QuickNioServer quickNioServer) {
        Logger.error((Throwable)exc);
    }
}

