/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.nio.channels.CompletionHandler;
import org.aoju.bus.socket.NetMonitor;
import org.aoju.bus.socket.SocketStatus;
import org.aoju.bus.socket.TcpAioSession;

public class CompletionWriteHandler<T>
implements CompletionHandler<Integer, TcpAioSession<T>> {
    @Override
    public void completed(Integer result, TcpAioSession<T> aioSession) {
        try {
            NetMonitor monitor = aioSession.getServerConfig().getMonitor();
            if (monitor != null) {
                monitor.afterWrite(aioSession, result);
            }
            aioSession.writeCompleted();
        }
        catch (Exception e) {
            this.failed((Throwable)e, aioSession);
        }
    }

    @Override
    public void failed(Throwable exc, TcpAioSession<T> aioSession) {
        try {
            aioSession.getServerConfig().getProcessor().stateEvent(aioSession, SocketStatus.OUTPUT_EXCEPTION, exc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            aioSession.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

