/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.socket.CompletionReadHandler;
import org.aoju.bus.socket.TcpAioSession;

public class ConcurrentReadHandler<T>
extends CompletionReadHandler<T> {
    private final Semaphore semaphore;
    private final ThreadLocal<ConcurrentReadHandler<T>> threadLocal = new ThreadLocal();
    private final LinkedBlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue();
    private final ExecutorService executorService = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, this.taskQueue);

    ConcurrentReadHandler(Semaphore semaphore) {
        this.semaphore = semaphore;
    }

    @Override
    public void completed(Integer result, TcpAioSession<T> aioSession) {
        if (this.threadLocal.get() != null) {
            super.completed(result, aioSession);
            return;
        }
        if (this.semaphore.tryAcquire()) {
            Runnable task;
            this.threadLocal.set(this);
            super.completed(result, aioSession);
            while ((task = this.taskQueue.poll()) != null) {
                task.run();
            }
            this.semaphore.release();
            this.threadLocal.set(null);
            return;
        }
        this.executorService.execute(() -> ConcurrentReadHandler.super.completed(result, aioSession));
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }
}

