/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.socket.SocketDecoder;

public class DelimiterFrameDecoder
implements SocketDecoder {
    private final List<ByteBuffer> bufferList;
    private byte[] endFLag;
    private int exceptIndex;
    private boolean finishRead;
    private int position;

    public DelimiterFrameDecoder(byte[] endFLag, int unitBufferSize) {
        this.endFLag = endFLag;
        this.bufferList = new ArrayList<ByteBuffer>();
        this.bufferList.add(ByteBuffer.allocate(unitBufferSize));
    }

    @Override
    public boolean decode(ByteBuffer byteBuffer) {
        if (this.finishRead) {
            throw new RuntimeException("delimiter has finish read");
        }
        ByteBuffer preBuffer = this.bufferList.get(this.position);
        while (byteBuffer.hasRemaining()) {
            if (!preBuffer.hasRemaining()) {
                preBuffer.flip();
                ++this.position;
                if (this.position < this.bufferList.size()) {
                    preBuffer = this.bufferList.get(this.position);
                    preBuffer.clear();
                } else {
                    preBuffer = ByteBuffer.allocate(preBuffer.capacity());
                    this.bufferList.add(preBuffer);
                }
            }
            byte data = byteBuffer.get();
            preBuffer.put(data);
            if (data != this.endFLag[this.exceptIndex]) {
                this.exceptIndex = 0;
                continue;
            }
            if (++this.exceptIndex != this.endFLag.length) continue;
            preBuffer.flip();
            this.finishRead = true;
            break;
        }
        return this.finishRead;
    }

    @Override
    public ByteBuffer getBuffer() {
        if (this.position == 0) {
            return this.bufferList.get(this.position);
        }
        byte[] data = new byte[this.position * this.bufferList.get(0).capacity() + this.bufferList.get(this.position).limit()];
        int index = 0;
        for (int i = 0; i < this.position; ++i) {
            ByteBuffer b = this.bufferList.get(i);
            System.arraycopy(b.array(), b.position(), data, index, b.remaining());
            index += b.remaining();
        }
        ByteBuffer lastBuffer = this.bufferList.get(this.position);
        System.arraycopy(lastBuffer.array(), lastBuffer.position(), data, index, lastBuffer.remaining());
        return ByteBuffer.wrap(data);
    }

    public void reset() {
        this.reset(null);
    }

    public void reset(byte[] endFLag) {
        if (endFLag != null) {
            this.endFLag = endFLag;
        }
        this.finishRead = false;
        this.exceptIndex = 0;
        this.position = 0;
        this.bufferList.get(this.position).clear();
    }
}

