/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.net.SocketOption;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.socket.BufferFactory;
import org.aoju.bus.socket.MessageProcessor;
import org.aoju.bus.socket.NetMonitor;
import org.aoju.bus.socket.Protocol;

public class ServerConfig<T> {
    private int readBufferSize = 512;
    private int writeBufferSize = 128;
    private int writeBufferCapacity = 16;
    private String host;
    private NetMonitor monitor;
    private int port = 8888;
    private int backlog = 1000;
    private MessageProcessor<T> processor;
    private Protocol<T> protocol;
    private Map<SocketOption<Object>, Object> socketOptions;
    private int threadNum = 1;
    private BufferFactory bufferFactory = BufferFactory.DISABLED_BUFFER_FACTORY;

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public NetMonitor getMonitor() {
        return this.monitor;
    }

    public Protocol<T> getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol<T> protocol) {
        this.protocol = protocol;
    }

    public MessageProcessor<T> getProcessor() {
        return this.processor;
    }

    public void setProcessor(MessageProcessor<T> processor) {
        this.processor = processor;
        this.monitor = processor instanceof NetMonitor ? (NetMonitor)((Object)processor) : null;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public Map<SocketOption<Object>, Object> getSocketOptions() {
        return this.socketOptions;
    }

    public void setOption(SocketOption socketOption, Object f) {
        if (this.socketOptions == null) {
            this.socketOptions = new HashMap<SocketOption<Object>, Object>(4);
        }
        this.socketOptions.put(socketOption, f);
    }

    public int getWriteBufferCapacity() {
        return this.writeBufferCapacity;
    }

    public void setWriteBufferCapacity(int writeBufferCapacity) {
        this.writeBufferCapacity = writeBufferCapacity;
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public void setThreadNum(int threadNum) {
        this.threadNum = threadNum;
    }

    public BufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    public void setBufferFactory(BufferFactory bufferFactory) {
        this.bufferFactory = bufferFactory;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public String toString() {
        return "ServerConfig{readBufferSize=" + this.readBufferSize + ", writeQueueCapacity=" + this.writeBufferCapacity + ", host='" + this.host + '\'' + ", monitor=" + this.monitor + ", port=" + this.port + ", processor=" + this.processor + ", protocol=" + this.protocol + ", socketOptions=" + this.socketOptions + ", threadNum=" + this.threadNum + ", writeBufferSize=" + this.writeBufferSize + '}';
    }
}

