/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.plugins;

import java.lang.reflect.Field;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.io.ByteBuffer;
import org.aoju.bus.core.io.PageBuffer;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.QuickAioServer;
import org.aoju.bus.socket.QuickTimer;
import org.aoju.bus.socket.plugins.AbstractPlugin;

public class PageBufferPlugin<T>
extends AbstractPlugin {
    private final QuickAioServer<T> server;
    private int seconds = 0;
    private ScheduledFuture<?> future;

    public PageBufferPlugin(QuickAioServer<T> server, int seconds) {
        this.seconds = seconds;
        this.server = server;
        this.init();
    }

    private void init() {
        long mills = TimeUnit.SECONDS.toMillis(this.seconds);
        this.future = QuickTimer.scheduleAtFixedRate(() -> {
            if (this.server == null) {
                Logger.error((String)"unKnow server or client need to monitor!", (Object[])new Object[0]);
                this.shutdown();
                return;
            }
            try {
                Field bufferPoolField = QuickAioServer.class.getDeclaredField("bufferPool");
                bufferPoolField.setAccessible(true);
                ByteBuffer pagePool = (ByteBuffer)bufferPoolField.get(this.server);
                if (pagePool == null) {
                    Logger.error((String)"server maybe has not started!", (Object[])new Object[0]);
                    this.shutdown();
                    return;
                }
                Field field = ByteBuffer.class.getDeclaredField("pageBuffers");
                field.setAccessible(true);
                PageBuffer[] pages = (PageBuffer[])field.get(pagePool);
                String logger = "";
                for (PageBuffer page : pages) {
                    logger = logger + "\r\n" + page.toString();
                }
                Logger.info((String)logger, (Object[])new Object[0]);
            }
            catch (Exception e) {
                Logger.error((String)"", (Object[])new Object[]{e});
            }
        }, mills, mills);
    }

    private void shutdown() {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
    }
}

