/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import org.aoju.bus.core.io.PageBuffer;
import org.aoju.bus.core.io.VirtualBuffer;
import org.aoju.bus.core.io.WriteBuffer;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.AioSession;
import org.aoju.bus.socket.ServerConfig;
import org.aoju.bus.socket.UdpAioSession;

public class UdpChannel<Request> {
    private final PageBuffer pageBuffer;
    private final ConcurrentHashMap<String, UdpAioSession> udpAioSessionConcurrentHashMap = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<ResponseTask> responseTasks;
    private final Semaphore writeSemaphore = new Semaphore(1);
    ServerConfig<Request> config;
    private DatagramChannel channel;
    private SelectionKey selectionKey;
    private ResponseTask failWriteEvent;

    UdpChannel(DatagramChannel channel, SelectionKey selectionKey, ServerConfig<Request> config, PageBuffer pageBuffer) {
        this.channel = channel;
        this.responseTasks = new ConcurrentLinkedQueue();
        this.selectionKey = selectionKey;
        this.pageBuffer = pageBuffer;
        this.config = config;
    }

    private void write(VirtualBuffer virtualBuffer, SocketAddress remote) throws IOException {
        if (this.writeSemaphore.tryAcquire() && this.responseTasks.isEmpty() && this.send(virtualBuffer.buffer(), remote) > 0) {
            virtualBuffer.clean();
            this.writeSemaphore.release();
            return;
        }
        this.responseTasks.offer(new ResponseTask(remote, virtualBuffer));
        if ((this.selectionKey.interestOps() & 4) == 0) {
            this.selectionKey.interestOps(this.selectionKey.interestOps() | 4);
        }
    }

    void flush() throws IOException {
        ResponseTask responseTask;
        while (true) {
            if (this.failWriteEvent == null) {
                responseTask = this.responseTasks.poll();
                Logger.info((String)"poll from writeBuffer", (Object[])new Object[0]);
            } else {
                responseTask = this.failWriteEvent;
                this.failWriteEvent = null;
            }
            if (responseTask == null) {
                this.writeSemaphore.release();
                if (this.responseTasks.isEmpty()) {
                    this.selectionKey.interestOps(this.selectionKey.interestOps() & 0xFFFFFFFB);
                    if (!this.responseTasks.isEmpty()) {
                        this.selectionKey.interestOps(this.selectionKey.interestOps() | 4);
                    }
                }
                return;
            }
            if (this.send(responseTask.response.buffer(), responseTask.remote) <= 0) break;
            responseTask.response.clean();
        }
        this.failWriteEvent = responseTask;
    }

    private int send(ByteBuffer byteBuffer, SocketAddress remote) throws IOException {
        AioSession aioSession = this.udpAioSessionConcurrentHashMap.get(this.getSessionKey(remote));
        if (this.config.getMonitor() != null) {
            this.config.getMonitor().beforeWrite(aioSession);
        }
        int size = this.channel.send(byteBuffer, remote);
        if (this.config.getMonitor() != null) {
            this.config.getMonitor().afterWrite(aioSession, size);
        }
        return size;
    }

    public AioSession connect(SocketAddress remote) {
        return this.createAndCacheSession(remote);
    }

    UdpAioSession createAndCacheSession(SocketAddress remote) {
        String key = this.getSessionKey(remote);
        UdpAioSession session = this.udpAioSessionConcurrentHashMap.computeIfAbsent(key, s -> {
            Consumer<WriteBuffer> consumer = writeBuffer -> {
                VirtualBuffer virtualBuffer = writeBuffer.poll();
                if (virtualBuffer == null) {
                    return;
                }
                try {
                    this.write(virtualBuffer, remote);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            };
            WriteBuffer writeBuffer2 = new WriteBuffer(this.pageBuffer, consumer, this.config.getWriteBufferSize(), 1);
            return new UdpAioSession(this, remote, writeBuffer2);
        });
        return session;
    }

    private String getSessionKey(SocketAddress remote) {
        if (!(remote instanceof InetSocketAddress)) {
            throw new UnsupportedOperationException();
        }
        InetSocketAddress address = (InetSocketAddress)remote;
        return address.getHostName() + ':' + address.getPort();
    }

    void removeSession(SocketAddress remote) {
        String key = this.getSessionKey(remote);
        UdpAioSession udpAioSession = this.udpAioSessionConcurrentHashMap.remove(key);
        Logger.info((String)"remove session:{}", (Object[])new Object[]{udpAioSession});
    }

    public void close() {
        ResponseTask task;
        if (this.selectionKey != null) {
            Selector selector = this.selectionKey.selector();
            this.selectionKey.cancel();
            selector.wakeup();
            this.selectionKey = null;
        }
        for (Map.Entry entry : this.udpAioSessionConcurrentHashMap.entrySet()) {
            ((UdpAioSession)entry.getValue()).close();
        }
        try {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
        }
        catch (IOException e) {
            Logger.error((String)"", (Object[])new Object[]{e});
        }
        while ((task = this.responseTasks.poll()) != null) {
            task.response.clean();
        }
    }

    DatagramChannel getChannel() {
        return this.channel;
    }

    static final class ResponseTask {
        private final SocketAddress remote;
        private final VirtualBuffer response;

        public ResponseTask(SocketAddress remote, VirtualBuffer response) {
            this.remote = remote;
            this.response = response;
        }
    }
}

