/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import org.aoju.bus.core.io.PageBuffer;
import org.aoju.bus.core.io.VirtualBuffer;
import org.aoju.bus.core.io.WriteBuffer;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.AioSession;
import org.aoju.bus.socket.ServerConfig;
import org.aoju.bus.socket.UdpAioSession;
import org.aoju.bus.socket.UdpBootstrap;

public class UdpChannel<Request> {
    private final PageBuffer pageBuffer;
    private final ConcurrentHashMap<SocketAddress, UdpAioSession> sessionMap = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<ResponseUnit> responseTasks;
    private final Semaphore writeSemaphore = new Semaphore(1);
    private final UdpBootstrap.Worker worker;
    ServerConfig<Request> config;
    private DatagramChannel channel;
    private SelectionKey selectionKey;
    private ResponseUnit failResponseUnit;

    UdpChannel(DatagramChannel channel, UdpBootstrap.Worker worker, ServerConfig config, PageBuffer pageBuffer) {
        this.channel = channel;
        this.responseTasks = new ConcurrentLinkedQueue();
        this.worker = worker;
        this.pageBuffer = pageBuffer;
        this.config = config;
    }

    private void write(VirtualBuffer virtualBuffer, SocketAddress remote) throws IOException {
        if (this.writeSemaphore.tryAcquire() && this.responseTasks.isEmpty() && this.send(virtualBuffer.buffer(), remote) > 0) {
            virtualBuffer.clean();
            this.writeSemaphore.release();
            return;
        }
        this.responseTasks.offer(new ResponseUnit(remote, virtualBuffer));
        if (this.selectionKey == null) {
            this.worker.addRegister(selector -> this.selectionKey.interestOps(this.selectionKey.interestOps() | 4));
        } else if ((this.selectionKey.interestOps() & 4) == 0) {
            this.selectionKey.interestOps(this.selectionKey.interestOps() | 4);
        }
    }

    void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    void doWrite() throws IOException {
        ResponseUnit responseUnit;
        while (true) {
            if (this.failResponseUnit == null) {
                responseUnit = this.responseTasks.poll();
                Logger.info((String)"poll from writeBuffer", (Object[])new Object[0]);
            } else {
                responseUnit = this.failResponseUnit;
                this.failResponseUnit = null;
            }
            if (responseUnit == null) {
                this.writeSemaphore.release();
                if (this.responseTasks.isEmpty()) {
                    this.selectionKey.interestOps(this.selectionKey.interestOps() & 0xFFFFFFFB);
                    if (!this.responseTasks.isEmpty()) {
                        this.selectionKey.interestOps(this.selectionKey.interestOps() | 4);
                    }
                }
                return;
            }
            if (this.send(responseUnit.response.buffer(), responseUnit.remote) <= 0) break;
            responseUnit.response.clean();
        }
        this.failResponseUnit = responseUnit;
    }

    private int send(ByteBuffer byteBuffer, SocketAddress remote) throws IOException {
        AioSession aioSession = this.sessionMap.get(remote);
        if (this.config.getMonitor() != null) {
            this.config.getMonitor().beforeWrite(aioSession);
        }
        int size = this.channel.send(byteBuffer, remote);
        if (this.config.getMonitor() != null) {
            this.config.getMonitor().afterWrite(aioSession, size);
        }
        return size;
    }

    public AioSession connect(SocketAddress remote) {
        return this.createAndCacheSession(remote);
    }

    public AioSession connect(String host, int port) {
        return this.connect(new InetSocketAddress(host, port));
    }

    UdpAioSession createAndCacheSession(SocketAddress remote) {
        return this.sessionMap.computeIfAbsent(remote, s -> {
            Consumer<WriteBuffer> consumer = writeBuffer -> {
                VirtualBuffer virtualBuffer = writeBuffer.poll();
                if (virtualBuffer == null) {
                    return;
                }
                try {
                    this.write(virtualBuffer, remote);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            };
            WriteBuffer writeBuffer2 = new WriteBuffer(this.pageBuffer, consumer, this.config.getWriteBufferSize(), 1);
            return new UdpAioSession(this, remote, writeBuffer2);
        });
    }

    void removeSession(SocketAddress remote) {
        UdpAioSession udpAioSession = this.sessionMap.remove(remote);
        Logger.info((String)"remove session:{}", (Object[])new Object[]{udpAioSession});
    }

    public void close() {
        ResponseUnit task;
        if (this.selectionKey != null) {
            Selector selector = this.selectionKey.selector();
            this.selectionKey.cancel();
            selector.wakeup();
            this.selectionKey = null;
        }
        for (UdpAioSession session : this.sessionMap.values()) {
            session.close();
        }
        try {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
        }
        catch (IOException e) {
            Logger.error((String)"", (Object[])new Object[]{e});
        }
        while ((task = this.responseTasks.poll()) != null) {
            task.response.clean();
        }
        if (this.failResponseUnit != null) {
            this.failResponseUnit.response.clean();
        }
    }

    DatagramChannel getChannel() {
        return this.channel;
    }

    static final class ResponseUnit {
        private final SocketAddress remote;
        private final VirtualBuffer response;

        public ResponseUnit(SocketAddress remote, VirtualBuffer response) {
            this.remote = remote;
            this.response = response;
        }
    }
}

