/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.plugins;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.socket.channel.AsynchronousSocketChannelProxy;
import org.aoju.bus.socket.plugins.AbstractPlugin;

public class StreamMonitorPlugin<T>
extends AbstractPlugin<T> {
    private final Consumer<byte[]> inputStreamConsumer;
    private final Consumer<byte[]> outputStreamConsumer;

    public StreamMonitorPlugin() {
        this(bytes -> {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            System.out.println("\u001b[34m" + simpleDateFormat.format(new Date()) + " [Input Stream]" + HexKit.encodeHexStr((byte[])bytes));
        }, bytes -> {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            System.err.println("\u001b[31m" + simpleDateFormat.format(new Date()) + " [Output Stream]" + HexKit.encodeHexStr((byte[])bytes));
        });
    }

    public StreamMonitorPlugin(Consumer<byte[]> inputStreamConsumer, Consumer<byte[]> outputStreamConsumer) {
        this.inputStreamConsumer = Objects.requireNonNull(inputStreamConsumer);
        this.outputStreamConsumer = Objects.requireNonNull(outputStreamConsumer);
    }

    @Override
    public AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        return new StreamMonitorAsynchronousSocketChannel(channel);
    }

    class StreamMonitorAsynchronousSocketChannel
    extends AsynchronousSocketChannelProxy {
        public StreamMonitorAsynchronousSocketChannel(AsynchronousSocketChannel asynchronousSocketChannel) {
            super(asynchronousSocketChannel);
        }

        @Override
        public <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
            super.read(dst, timeout, unit, attachment, new MonitorCompletionHandler<A>(handler, StreamMonitorPlugin.this.inputStreamConsumer, dst));
        }

        @Override
        public <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
            super.write(src, timeout, unit, attachment, new MonitorCompletionHandler<A>(handler, StreamMonitorPlugin.this.outputStreamConsumer, src));
        }
    }

    static class MonitorCompletionHandler<A>
    implements CompletionHandler<Integer, A> {
        CompletionHandler<Integer, A> handler;
        Consumer<byte[]> consumer;
        ByteBuffer buffer;

        public MonitorCompletionHandler(CompletionHandler<Integer, A> handler, Consumer<byte[]> consumer, ByteBuffer buffer) {
            this.handler = handler;
            this.consumer = consumer;
            this.buffer = buffer;
        }

        @Override
        public void completed(Integer result, A attachment) {
            if (result > 0) {
                byte[] bytes = new byte[result.intValue()];
                this.buffer.position(this.buffer.position() - result);
                this.buffer.get(bytes);
                this.consumer.accept(bytes);
            }
            this.handler.completed(result, attachment);
        }

        @Override
        public void failed(Throwable exc, A attachment) {
            this.handler.failed(exc, attachment);
        }
    }
}

