/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ThreadKit;
import org.aoju.bus.socket.handler.ChannelSocketHandler;

public class NioQuickClient
implements Closeable {
    private Selector selector;
    private SocketChannel channel;
    private ChannelSocketHandler handler;

    public NioQuickClient(String host, int port) {
        this.init(new InetSocketAddress(host, port));
    }

    public NioQuickClient(InetSocketAddress address) {
        this.init(address);
    }

    public NioQuickClient init(InetSocketAddress address) {
        try {
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(false);
            this.channel.connect(address);
            this.selector = Selector.open();
            this.channel.register(this.selector, 1);
            while (!this.channel.finishConnect()) {
            }
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        return this;
    }

    public NioQuickClient setChannelHandler(ChannelSocketHandler handler) {
        this.handler = handler;
        return this;
    }

    public void listen() {
        ThreadKit.execute(() -> {
            try {
                this.doListen();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void doListen() throws IOException {
        while (this.selector.isOpen() && 0 != this.selector.select()) {
            Iterator<SelectionKey> keyIter = this.selector.selectedKeys().iterator();
            while (keyIter.hasNext()) {
                this.handle(keyIter.next());
                keyIter.remove();
            }
        }
    }

    private void handle(SelectionKey key) {
        if (key.isReadable()) {
            SocketChannel socketChannel = (SocketChannel)key.channel();
            try {
                this.handler.handle(socketChannel);
            }
            catch (Exception e) {
                throw new InstrumentException((Throwable)e);
            }
        }
    }

    public NioQuickClient write(ByteBuffer ... datas) {
        try {
            this.channel.write(datas);
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        return this;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    @Override
    public void close() {
        IoKit.close((Closeable)this.selector);
        IoKit.close((Closeable)this.channel);
    }
}

