/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.channel;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.channel.AsynchronousServerSocketChannel;
import org.aoju.bus.socket.channel.AsynchronousSocketChannel;

public class AsynchronousChannelGroup
extends java.nio.channels.AsynchronousChannelGroup {
    public static final int MAX_INVOKER = 8;
    private final ExecutorService readExecutorService;
    private final ExecutorService writeExecutorService;
    private final Worker[] writeWorkers;
    private final Worker[] readWorkers;
    private final AtomicInteger readIndex = new AtomicInteger(0);
    private final AtomicInteger writeIndex = new AtomicInteger(0);
    private final ScheduledThreadPoolExecutor scheduledExecutor;
    private final ExecutorService acceptExecutorService;
    private final Worker[] acceptWorkers;
    private Worker futureWorker;
    private ExecutorService futureExecutorService;
    private boolean running = true;

    protected AsynchronousChannelGroup(AsynchronousChannelProvider provider, ExecutorService readExecutorService, int threadNum) throws IOException {
        super(provider);
        int i;
        this.readExecutorService = readExecutorService;
        this.readWorkers = new Worker[threadNum];
        for (int i2 = 0; i2 < threadNum; ++i2) {
            this.readWorkers[i2] = new Worker(selectionKey -> {
                AsynchronousSocketChannel asynchronousSocketChannel = (AsynchronousSocketChannel)selectionKey.attachment();
                asynchronousSocketChannel.doRead(true);
            });
            this.readExecutorService.execute(this.readWorkers[i2]);
        }
        boolean writeThreadNum = true;
        boolean acceptThreadNum = true;
        this.writeExecutorService = this.getThreadPoolExecutor("bus-socket:write-", 1);
        this.writeWorkers = new Worker[1];
        for (i = 0; i < 1; ++i) {
            this.writeWorkers[i] = new Worker(selectionKey -> {
                AsynchronousSocketChannel asynchronousSocketChannel = (AsynchronousSocketChannel)selectionKey.attachment();
                if ((selectionKey.interestOps() & 4) > 0) {
                    asynchronousSocketChannel.doWrite();
                } else {
                    Logger.warn((String)"ignore write", (Object[])new Object[0]);
                }
            });
            this.writeExecutorService.execute(this.writeWorkers[i]);
        }
        this.acceptExecutorService = this.getThreadPoolExecutor("bus-socket:connect-", 1);
        this.acceptWorkers = new Worker[1];
        for (i = 0; i < 1; ++i) {
            this.acceptWorkers[i] = new Worker(selectionKey -> {
                if (selectionKey.isAcceptable()) {
                    AsynchronousServerSocketChannel serverSocketChannel = (AsynchronousServerSocketChannel)selectionKey.attachment();
                    serverSocketChannel.doAccept();
                } else if (selectionKey.isConnectable()) {
                    AsynchronousSocketChannel asynchronousSocketChannel = (AsynchronousSocketChannel)selectionKey.attachment();
                    asynchronousSocketChannel.doConnect();
                }
            });
            this.acceptExecutorService.execute(this.acceptWorkers[i]);
        }
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "bus-socket:scheduled"));
    }

    public synchronized void registerFuture(Consumer<Selector> register, int opType) throws IOException {
        if (this.futureWorker == null) {
            this.futureExecutorService = this.getThreadPoolExecutor("bus-socket:future-", 1);
            this.futureWorker = new Worker(selectionKey -> {
                AsynchronousSocketChannel asynchronousSocketChannel = (AsynchronousSocketChannel)selectionKey.attachment();
                switch (opType) {
                    case 1: {
                        this.removeOps((SelectionKey)selectionKey, 1);
                        asynchronousSocketChannel.doRead(true);
                        break;
                    }
                    case 4: {
                        this.removeOps((SelectionKey)selectionKey, 4);
                        asynchronousSocketChannel.doWrite();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("unSupport opType: " + opType);
                    }
                }
            });
            this.futureExecutorService.execute(this.futureWorker);
        }
        this.futureWorker.addRegister(register);
    }

    private ThreadPoolExecutor getThreadPoolExecutor(final String prefix, int threadNum) {
        return new ThreadPoolExecutor(threadNum, threadNum, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, prefix + this.atomicInteger.getAndIncrement());
            }
        });
    }

    public void removeOps(SelectionKey selectionKey, int opt) {
        if (selectionKey.isValid() && (selectionKey.interestOps() & opt) != 0) {
            selectionKey.interestOps(selectionKey.interestOps() & ~opt);
        }
    }

    public Worker getReadWorker() {
        return this.readWorkers[(this.readIndex.getAndIncrement() & Integer.MAX_VALUE) % this.readWorkers.length];
    }

    public Worker getWriteWorker() {
        return this.writeWorkers[(this.writeIndex.getAndIncrement() & Integer.MAX_VALUE) % this.writeWorkers.length];
    }

    public Worker getAcceptWorker() {
        return this.acceptWorkers[(this.writeIndex.getAndIncrement() & Integer.MAX_VALUE) % this.acceptWorkers.length];
    }

    public Worker getConnectWorker() {
        return this.acceptWorkers[(this.writeIndex.getAndIncrement() & Integer.MAX_VALUE) % this.acceptWorkers.length];
    }

    public ScheduledThreadPoolExecutor getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    @Override
    public boolean isShutdown() {
        return this.readExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.readExecutorService.isTerminated();
    }

    @Override
    public void shutdown() {
        this.running = false;
        this.readExecutorService.shutdown();
        this.writeExecutorService.shutdown();
        if (this.acceptExecutorService != null) {
            this.acceptExecutorService.shutdown();
        }
        if (this.futureExecutorService != null) {
            this.futureExecutorService.shutdown();
        }
        this.scheduledExecutor.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.running = false;
        this.readExecutorService.shutdownNow();
        this.writeExecutorService.shutdownNow();
        if (this.acceptExecutorService != null) {
            this.acceptExecutorService.shutdownNow();
        }
        if (this.futureExecutorService != null) {
            this.futureExecutorService.shutdownNow();
        }
        this.scheduledExecutor.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.readExecutorService.awaitTermination(timeout, unit);
    }

    public void interestOps(Worker worker, SelectionKey selectionKey, int opt) {
        if ((selectionKey.interestOps() & opt) != 0) {
            return;
        }
        selectionKey.interestOps(selectionKey.interestOps() | opt);
        if (worker.getWorkerThread() != Thread.currentThread()) {
            selectionKey.selector().wakeup();
        }
    }

    class Worker
    implements Runnable {
        private final Selector selector;
        private final ConcurrentLinkedQueue<Consumer<Selector>> registers = new ConcurrentLinkedQueue();
        private final Consumer<SelectionKey> consumer;
        int invoker = 0;
        int modCount;
        private Thread workerThread;

        Worker(Consumer<SelectionKey> consumer) throws IOException {
            this.selector = Selector.open();
            this.consumer = consumer;
        }

        final void addRegister(Consumer<Selector> register) {
            this.registers.offer(register);
            ++this.modCount;
            this.selector.wakeup();
        }

        public final Thread getWorkerThread() {
            return this.workerThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            this.workerThread = Thread.currentThread();
            Set<SelectionKey> keySet = this.selector.selectedKeys();
            try {
                int v = 0;
                while (AsynchronousChannelGroup.this.running) {
                    if (v != this.modCount) {
                        Consumer<Selector> register;
                        v = this.modCount;
                        while ((register = this.registers.poll()) != null) {
                            register.accept(this.selector);
                        }
                    }
                    this.selector.select();
                    for (SelectionKey key : keySet) {
                        this.invoker = 0;
                        this.consumer.accept(key);
                    }
                    keySet.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.selector.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

