/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.logger.Logger;

public abstract class QuickTimer
implements Runnable {
    public static final ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE = new ScheduledThreadPoolExecutor(1, r -> {
        Thread thread = new Thread(r, "Quick Timer");
        thread.setDaemon(true);
        return thread;
    });

    public QuickTimer() {
        SCHEDULED_EXECUTOR_SERVICE.scheduleAtFixedRate(this, this.getDelay(), this.getPeriod(), TimeUnit.MILLISECONDS);
        Logger.info((String)("Register QuickTimer---- " + this.getClass().getSimpleName()), (Object[])new Object[0]);
    }

    public static void cancelQuickTask() {
        SCHEDULED_EXECUTOR_SERVICE.shutdown();
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period) {
        return SCHEDULED_EXECUTOR_SERVICE.scheduleAtFixedRate(command, initialDelay, period, TimeUnit.MILLISECONDS);
    }

    protected long getDelay() {
        return 0L;
    }

    protected abstract long getPeriod();
}

