/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.aoju.bus.core.io.ByteBuffer;
import org.aoju.bus.core.io.PageBuffer;
import org.aoju.bus.core.io.VirtualBuffer;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.socket.NetMonitor;
import org.aoju.bus.socket.Protocol;
import org.aoju.bus.socket.ServerConfig;
import org.aoju.bus.socket.SocketStatus;
import org.aoju.bus.socket.UdpAioSession;
import org.aoju.bus.socket.UdpChannel;
import org.aoju.bus.socket.UdpDispatcher;
import org.aoju.bus.socket.process.MessageProcessor;

public class UdpBootstrap<R> {
    private static final int MAX_READ_TIMES = 16;
    private static int UID;
    private final PageBuffer bufferPage = new ByteBuffer(0x100000, 1, true).allocatePageBuffer();
    private final ServerConfig config = new ServerConfig();
    private Worker worker;
    private UdpDispatcher[] workerGroup;
    private ExecutorService executorService;
    private boolean running = true;

    public UdpBootstrap(Protocol<R> protocol, MessageProcessor<R> messageProcessor) {
        this.config.setProtocol(protocol);
        this.config.setProcessor(messageProcessor);
    }

    public UdpChannel<R> open() throws IOException {
        return this.open(0);
    }

    public UdpChannel<R> open(int port) throws IOException {
        return this.open(null, port);
    }

    public UdpChannel<R> open(String host, int port) throws IOException {
        if (null == this.worker) {
            this.initThreadServer();
        }
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        if (port > 0) {
            InetSocketAddress inetSocketAddress = null == host ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
            channel.socket().bind(inetSocketAddress);
        }
        UdpChannel udpChannel = new UdpChannel(channel, this.worker, this.config, this.bufferPage);
        this.worker.addRegister(selector -> {
            try {
                SelectionKey selectionKey = channel.register((Selector)selector, 1);
                udpChannel.setSelectionKey(selectionKey);
                selectionKey.attach(udpChannel);
            }
            catch (ClosedChannelException e) {
                e.printStackTrace();
            }
        });
        return udpChannel;
    }

    private synchronized void initThreadServer() throws IOException {
        if (null != this.worker) {
            return;
        }
        final int uid = UID++;
        this.workerGroup = new UdpDispatcher[this.config.getThreadNum()];
        this.executorService = new ThreadPoolExecutor(this.config.getThreadNum(), this.config.getThreadNum(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            int i = 0;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "socket:udp-" + uid + "-" + ++this.i);
            }
        });
        for (int i = 0; i < this.config.getThreadNum(); ++i) {
            this.workerGroup[i] = new UdpDispatcher(this.config.getProcessor());
            this.executorService.execute(this.workerGroup[i]);
        }
        this.worker = new Worker();
        new Thread((Runnable)this.worker, "socket:udp-" + uid).start();
    }

    private void doRead(VirtualBuffer readBuffer, UdpChannel channel) throws IOException {
        int count = 16;
        while (count-- > 0) {
            Object request;
            java.nio.ByteBuffer buffer = readBuffer.buffer();
            buffer.clear();
            SocketAddress remote = channel.getChannel().receive(buffer);
            if (null == remote) {
                return;
            }
            buffer.flip();
            UdpAioSession aioSession = channel.createAndCacheSession(remote);
            NetMonitor netMonitor = this.config.getMonitor();
            if (null != netMonitor) {
                netMonitor.beforeRead(aioSession);
                netMonitor.afterRead(aioSession, buffer.remaining());
            }
            try {
                request = this.config.getProtocol().decode(buffer, aioSession);
            }
            catch (Exception e) {
                this.config.getProcessor().stateEvent(aioSession, SocketStatus.DECODE_EXCEPTION, e);
                aioSession.close();
                throw e;
            }
            if (null == request) {
                this.config.getProcessor().stateEvent(aioSession, SocketStatus.DECODE_EXCEPTION, (Throwable)new InstrumentException("decode result is null"));
                continue;
            }
            this.workerGroup[(remote.hashCode() & Integer.MAX_VALUE) % this.workerGroup.length].dispatch(aioSession, request);
        }
    }

    public void shutdown() {
        this.running = false;
        this.worker.selector.wakeup();
        for (UdpDispatcher dispatcher : this.workerGroup) {
            dispatcher.dispatch(UdpDispatcher.EXECUTE_TASK_OR_SHUTDOWN);
        }
        this.executorService.shutdown();
    }

    public final UdpBootstrap<R> setReadBufferSize(int size) {
        this.config.setReadBufferSize(size);
        return this;
    }

    public final UdpBootstrap<R> setThreadNum(int num) {
        this.config.setThreadNum(num);
        return this;
    }

    class Worker
    implements Runnable {
        private final Selector selector;
        private final ConcurrentLinkedQueue<Consumer<Selector>> registers = new ConcurrentLinkedQueue();

        Worker() throws IOException {
            this.selector = Selector.open();
        }

        final void addRegister(Consumer<Selector> register) {
            this.registers.offer(register);
            this.selector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Set<SelectionKey> keySet = this.selector.selectedKeys();
            VirtualBuffer readBuffer = UdpBootstrap.this.bufferPage.allocate(UdpBootstrap.this.config.getReadBufferSize());
            try {
                while (UdpBootstrap.this.running) {
                    Consumer<Selector> register;
                    while (null != (register = this.registers.poll())) {
                        register.accept(this.selector);
                    }
                    if (keySet.isEmpty() && this.selector.select() == 0) continue;
                    Iterator<SelectionKey> keyIterator = keySet.iterator();
                    while (keyIterator.hasNext()) {
                        SelectionKey key = keyIterator.next();
                        keyIterator.remove();
                        UdpChannel udpChannel = (UdpChannel)key.attachment();
                        if (!key.isValid()) {
                            udpChannel.close();
                            continue;
                        }
                        if (key.isReadable()) {
                            UdpBootstrap.this.doRead(readBuffer, udpChannel);
                        }
                        if (!key.isWritable()) continue;
                        udpChannel.doWrite();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                readBuffer.clean();
            }
        }
    }
}

