/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.handler;

import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import org.aoju.bus.socket.TcpAioSession;
import org.aoju.bus.socket.handler.CompletionReadHandler;

public class ConcurrentReadHandler<T>
extends CompletionReadHandler<T> {
    private final Semaphore semaphore;
    private final ThreadLocal<ConcurrentReadHandler> threadLocal = new ThreadLocal();
    private final ThreadPoolExecutor threadPoolExecutor;

    public ConcurrentReadHandler(Semaphore semaphore, ThreadPoolExecutor threadPoolExecutor) {
        this.semaphore = semaphore;
        this.threadPoolExecutor = threadPoolExecutor;
    }

    @Override
    public void completed(Integer result, TcpAioSession aioSession) {
        if (this.threadLocal.get() != null) {
            super.completed(result, aioSession);
            return;
        }
        if (this.semaphore.tryAcquire()) {
            Runnable task;
            this.threadLocal.set(this);
            super.completed(result, aioSession);
            while ((task = (Runnable)this.threadPoolExecutor.getQueue().poll()) != null) {
                task.run();
            }
            this.semaphore.release();
            this.threadLocal.set(null);
            return;
        }
        this.threadPoolExecutor.execute(() -> ConcurrentReadHandler.super.completed(result, aioSession));
    }
}

