/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.UdpAioSession;
import org.aoju.bus.socket.process.MessageProcessor;

public class UdpDispatcher
implements Runnable {
    public static final RequestTask EXECUTE_TASK_OR_SHUTDOWN = new RequestTask(null, null);
    private final BlockingQueue<RequestTask> taskQueue = new LinkedBlockingQueue<RequestTask>();
    private final MessageProcessor processor;

    public UdpDispatcher(MessageProcessor processor) {
        this.processor = processor;
    }

    @Override
    public void run() {
        block3: while (true) {
            try {
                while (true) {
                    RequestTask unit;
                    if ((unit = this.taskQueue.take()) == EXECUTE_TASK_OR_SHUTDOWN) {
                        Logger.info((String)"shutdown thread:{}", (Object[])new Object[]{Thread.currentThread()});
                        break block3;
                    }
                    this.processor.process(unit.session, unit.request);
                    if (unit.session.isInvalid()) continue;
                    unit.session.writeBuffer().flush();
                }
            }
            catch (InterruptedException e) {
                Logger.info((String)"InterruptedException", (Object[])new Object[]{e});
                continue;
            }
            catch (Exception e) {
                Logger.error((String)e.getClass().getName(), (Object[])new Object[]{e});
                continue;
            }
            break;
        }
    }

    public void dispatch(UdpAioSession session, Object request) {
        this.dispatch(new RequestTask(session, request));
    }

    public void dispatch(RequestTask requestTask) {
        this.taskQueue.offer(requestTask);
    }

    static class RequestTask {
        UdpAioSession session;
        Object request;

        public RequestTask(UdpAioSession session, Object request) {
            this.session = session;
            this.request = request;
        }
    }
}

