/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.security;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.aoju.bus.core.io.PageBuffer;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.security.ClientAuth;
import org.aoju.bus.socket.security.HandshakeModel;

public class SslService {
    private final boolean isClient;
    private final ClientAuth clientAuth;
    private SSLContext sslContext;
    private final CompletionHandler<Integer, HandshakeModel> handshakeCompletionHandler = new CompletionHandler<Integer, HandshakeModel>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(Integer result, HandshakeModel attachment) {
            if (result == -1) {
                attachment.setEof(true);
            }
            HandshakeModel handshakeModel = attachment;
            synchronized (handshakeModel) {
                SslService.this.doHandshake(attachment);
            }
        }

        @Override
        public void failed(Throwable exc, HandshakeModel attachment) {
            attachment.setEof(true);
            attachment.getHandshakeCallback().callback();
        }
    };

    public SslService(boolean isClient, ClientAuth clientAuth) {
        this.isClient = isClient;
        this.clientAuth = clientAuth;
    }

    public void initKeyStore(InputStream keyStoreInputStream, String keyStorePassword, String keyPassword) {
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(keyStoreInputStream, keyStorePassword.toCharArray());
            kmf.init(ks, keyPassword.toCharArray());
            KeyManager[] keyManagers = kmf.getKeyManagers();
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(keyManagers, null, new SecureRandom());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initTrust(InputStream trustInputStream, String trustPassword) {
        try {
            TrustManager[] trustManagers;
            if (null != trustInputStream) {
                KeyStore ts = KeyStore.getInstance("JKS");
                ts.load(trustInputStream, trustPassword.toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(ts);
                trustManagers = tmf.getTrustManagers();
            } else {
                trustManagers = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
            }
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(null, trustManagers, new SecureRandom());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    HandshakeModel createSSLEngine(AsynchronousSocketChannel socketChannel, PageBuffer pageBuffer) {
        try {
            HandshakeModel handshakeModel = new HandshakeModel();
            SSLEngine sslEngine = this.sslContext.createSSLEngine();
            SSLSession session = sslEngine.getSession();
            sslEngine.setUseClientMode(this.isClient);
            if (null != this.clientAuth) {
                switch (this.clientAuth) {
                    case OPTIONAL: {
                        sslEngine.setWantClientAuth(true);
                        break;
                    }
                    case REQUIRE: {
                        sslEngine.setNeedClientAuth(true);
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        throw new Error("Unknown auth " + this.clientAuth);
                    }
                }
            }
            handshakeModel.setSslEngine(sslEngine);
            handshakeModel.setAppWriteBuffer(pageBuffer.allocate(session.getApplicationBufferSize()));
            handshakeModel.setNetWriteBuffer(pageBuffer.allocate(session.getPacketBufferSize()));
            handshakeModel.getNetWriteBuffer().buffer().flip();
            handshakeModel.setAppReadBuffer(pageBuffer.allocate(session.getApplicationBufferSize()));
            handshakeModel.setNetReadBuffer(pageBuffer.allocate(session.getPacketBufferSize()));
            sslEngine.beginHandshake();
            handshakeModel.setSocketChannel(socketChannel);
            return handshakeModel;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void doHandshake(HandshakeModel handshakeModel) {
        try {
            ByteBuffer netReadBuffer = handshakeModel.getNetReadBuffer().buffer();
            ByteBuffer appReadBuffer = handshakeModel.getAppReadBuffer().buffer();
            ByteBuffer netWriteBuffer = handshakeModel.getNetWriteBuffer().buffer();
            ByteBuffer appWriteBuffer = handshakeModel.getAppWriteBuffer().buffer();
            SSLEngine engine = handshakeModel.getSslEngine();
            if (handshakeModel.isEof()) {
                Logger.info((String)"the ssl handshake is terminated", (Object[])new Object[0]);
                handshakeModel.getHandshakeCallback().callback();
                return;
            }
            block22: while (!handshakeModel.isFinished()) {
                SSLEngineResult.HandshakeStatus handshakeStatus = engine.getHandshakeStatus();
                if (Logger.isDebug()) {
                    Logger.info((String)("\u63e1\u624b\u72b6\u6001:" + handshakeStatus), (Object[])new Object[0]);
                }
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        netReadBuffer.flip();
                        if (!netReadBuffer.hasRemaining()) {
                            netReadBuffer.clear();
                            handshakeModel.getSocketChannel().read(netReadBuffer, handshakeModel, this.handshakeCompletionHandler);
                            return;
                        }
                        SSLEngineResult result = engine.unwrap(netReadBuffer, appReadBuffer);
                        netReadBuffer.compact();
                        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                            handshakeModel.setFinished(true);
                            netReadBuffer.clear();
                        }
                        switch (result.getStatus()) {
                            case OK: {
                                continue block22;
                            }
                            case BUFFER_OVERFLOW: {
                                Logger.warn((String)"doHandshake BUFFER_OVERFLOW", (Object[])new Object[0]);
                                continue block22;
                            }
                            case BUFFER_UNDERFLOW: {
                                Logger.warn((String)"doHandshake BUFFER_UNDERFLOW", (Object[])new Object[0]);
                                return;
                            }
                        }
                        throw new IllegalStateException("Invalid SSL status: " + result.getStatus());
                    }
                    case NEED_WRAP: {
                        if (netWriteBuffer.hasRemaining()) {
                            Logger.info((String)"\u6570\u636e\u672a\u8f93\u51fa\u5b8c\u6bd5...", (Object[])new Object[0]);
                            handshakeModel.getSocketChannel().write(netWriteBuffer, handshakeModel, this.handshakeCompletionHandler);
                            return;
                        }
                        netWriteBuffer.clear();
                        SSLEngineResult result = engine.wrap(appWriteBuffer, netWriteBuffer);
                        switch (result.getStatus()) {
                            case OK: {
                                appWriteBuffer.clear();
                                netWriteBuffer.flip();
                                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                                    handshakeModel.setFinished(true);
                                }
                                handshakeModel.getSocketChannel().write(netWriteBuffer, handshakeModel, this.handshakeCompletionHandler);
                                return;
                            }
                            case BUFFER_OVERFLOW: {
                                Logger.warn((String)"NEED_WRAP BUFFER_OVERFLOW", (Object[])new Object[0]);
                                continue block22;
                            }
                            case BUFFER_UNDERFLOW: {
                                throw new SSLException("Buffer underflow occured after a wrap. I don't think we should ever get here.");
                            }
                            case CLOSED: {
                                Logger.warn((String)"closed", (Object[])new Object[0]);
                                try {
                                    netWriteBuffer.flip();
                                    netReadBuffer.clear();
                                }
                                catch (Exception e) {
                                    Logger.warn((String)"Failed to send server's CLOSE message due to socket channel's failure.", (Object[])new Object[0]);
                                }
                                continue block22;
                            }
                        }
                        throw new IllegalStateException("Invalid SSL status: " + result.getStatus());
                    }
                    case NEED_TASK: {
                        Runnable task;
                        while (null != (task = engine.getDelegatedTask())) {
                            task.run();
                        }
                        continue block22;
                    }
                    case FINISHED: {
                        Logger.info((String)"HandshakeFinished", (Object[])new Object[0]);
                        continue block22;
                    }
                    case NOT_HANDSHAKING: {
                        Logger.error((String)"NOT_HANDSHAKING", (Object[])new Object[0]);
                        continue block22;
                    }
                }
                throw new IllegalStateException("Invalid SSL status: " + handshakeStatus);
            }
            handshakeModel.getHandshakeCallback().callback();
        }
        catch (Exception e) {
            Logger.warn((String)"ignore doHandshake exception: {}", (Object[])new Object[]{e.getMessage()});
            handshakeModel.setEof(true);
            handshakeModel.getHandshakeCallback().callback();
        }
    }
}

