/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.AioSession;
import org.aoju.bus.socket.Protocol;
import org.aoju.bus.socket.ServerConfig;
import org.aoju.bus.socket.SocketStatus;
import org.aoju.bus.socket.TcpAioSession;
import org.aoju.bus.socket.buffers.BufferFactory;
import org.aoju.bus.socket.buffers.BufferPool;
import org.aoju.bus.socket.buffers.VirtualBuffer;
import org.aoju.bus.socket.buffers.VirtualFactory;
import org.aoju.bus.socket.channel.EnhanceAsynchronousChannelProvider;
import org.aoju.bus.socket.handler.ConcurrentReadCompletionHandler;
import org.aoju.bus.socket.handler.ReadCompletionHandler;
import org.aoju.bus.socket.handler.WriteCompletionHandler;
import org.aoju.bus.socket.process.MessageProcessor;

public final class AioQuickServer {
    private final ServerConfig config = new ServerConfig();
    private BufferPool bufferPool;
    private ReadCompletionHandler aioReadCompletionHandler;
    private ThreadPoolExecutor concurrentReadCompletionHandlerExecutor;
    private WriteCompletionHandler aioWriteCompletionHandler;
    private BufferPool innerBufferPool = null;
    private AsynchronousServerSocketChannel serverSocketChannel = null;
    private AsynchronousChannelGroup asynchronousChannelGroup;
    private VirtualFactory readBufferFactory = bufferPage -> bufferPage.allocate(this.config.getReadBufferSize());

    public <T> AioQuickServer(int port, Protocol<T> protocol, MessageProcessor<T> messageProcessor) {
        this.config.setPort(port);
        this.config.setProtocol(protocol);
        this.config.setProcessor(messageProcessor);
        this.config.setThreadNum(Runtime.getRuntime().availableProcessors());
    }

    public <T> AioQuickServer(String host, int port, Protocol<T> protocol, MessageProcessor<T> messageProcessor) {
        this(port, protocol, messageProcessor);
        this.config.setHost(host);
    }

    public void start() throws IOException {
        this.start0();
    }

    private void start0() throws IOException {
        this.checkAndResetConfig();
        try {
            AsynchronousChannelProvider provider;
            this.aioWriteCompletionHandler = new WriteCompletionHandler();
            if (this.bufferPool == null) {
                this.innerBufferPool = this.bufferPool = this.config.getBufferFactory().create();
            }
            if (this.config.isAioEnhance()) {
                this.aioReadCompletionHandler = new ReadCompletionHandler();
                provider = new EnhanceAsynchronousChannelProvider(this.config.isLowMemory());
            } else {
                this.concurrentReadCompletionHandlerExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
                this.aioReadCompletionHandler = new ConcurrentReadCompletionHandler(new Semaphore(this.config.getThreadNum() - 1), this.concurrentReadCompletionHandlerExecutor);
                provider = AsynchronousChannelProvider.provider();
            }
            this.asynchronousChannelGroup = ((AsynchronousChannelProvider)provider).openAsynchronousChannelGroup(this.config.getThreadNum(), new ThreadFactory(){
                private byte index = 0;

                @Override
                public Thread newThread(Runnable r) {
                    this.index = (byte)(this.index + 1);
                    return AioQuickServer.this.bufferPool.newThread(r, "bus-socket:Thread-" + this.index);
                }
            });
            this.serverSocketChannel = AsynchronousServerSocketChannel.open(this.asynchronousChannelGroup);
            if (this.config.getSocketOptions() != null) {
                for (Map.Entry<SocketOption<Object>, Object> entry : this.config.getSocketOptions().entrySet()) {
                    this.serverSocketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
                }
            }
            if (this.config.getHost() != null) {
                this.serverSocketChannel.bind(new InetSocketAddress(this.config.getHost(), this.config.getPort()), this.config.getBacklog());
            } else {
                this.serverSocketChannel.bind(new InetSocketAddress(this.config.getPort()), this.config.getBacklog());
            }
            this.startAcceptThread();
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
        Logger.debug((String)("socket server started on port " + this.config.getPort() + ",threadNum:" + this.config.getThreadNum()), (Object[])new Object[0]);
        Logger.debug((String)("socket server config is " + String.valueOf(this.config)), (Object[])new Object[0]);
    }

    private void startAcceptThread() {
        final Supplier<VirtualBuffer> supplier = () -> this.readBufferFactory.newBuffer(this.bufferPool.allocateBufferPage());
        this.serverSocketChannel.accept(null, new CompletionHandler<AsynchronousSocketChannel, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(AsynchronousSocketChannel channel, Void attachment) {
                try {
                    AioQuickServer.this.serverSocketChannel.accept(attachment, this);
                }
                catch (Throwable throwable) {
                    AioQuickServer.this.config.getProcessor().stateEvent(null, SocketStatus.ACCEPT_EXCEPTION, throwable);
                    this.failed(throwable, attachment);
                    AioQuickServer.this.serverSocketChannel.accept(attachment, this);
                }
                finally {
                    AioQuickServer.this.createSession(channel, supplier);
                }
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                exc.printStackTrace();
            }
        });
    }

    private void checkAndResetConfig() {
        if (this.config.getThreadNum() == 1) {
            this.config.setThreadNum(2);
        }
    }

    private void createSession(AsynchronousSocketChannel channel, Supplier<VirtualBuffer> supplier) {
        AioSession session = null;
        AsynchronousSocketChannel acceptChannel = channel;
        try {
            if (this.config.getMonitor() != null) {
                acceptChannel = this.config.getMonitor().shouldAccept(channel);
            }
            if (acceptChannel != null) {
                acceptChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                session = new TcpAioSession(acceptChannel, this.config, this.aioReadCompletionHandler, this.aioWriteCompletionHandler, this.bufferPool.allocateBufferPage(), supplier);
            } else {
                this.config.getProcessor().stateEvent(null, SocketStatus.REJECT_ACCEPT, null);
                IoKit.close((AsynchronousSocketChannel)channel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (session == null) {
                IoKit.close((AsynchronousSocketChannel)channel);
            }
            session.close();
        }
    }

    public void shutdown() {
        try {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
                this.serverSocketChannel = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!this.asynchronousChannelGroup.isTerminated()) {
            try {
                this.asynchronousChannelGroup.shutdownNow();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.asynchronousChannelGroup.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.innerBufferPool != null) {
            this.innerBufferPool.release();
        }
        if (this.concurrentReadCompletionHandlerExecutor != null) {
            this.concurrentReadCompletionHandlerExecutor.shutdown();
            this.concurrentReadCompletionHandlerExecutor = null;
        }
    }

    public AioQuickServer setReadBufferSize(int size) {
        this.config.setReadBufferSize(size);
        return this;
    }

    public AioQuickServer setAioEnhance(boolean enabled) {
        this.config.setAioEnhance(enabled);
        return this;
    }

    public <V> AioQuickServer setOption(SocketOption<V> socketOption, V value) {
        this.config.setOption(socketOption, value);
        return this;
    }

    public AioQuickServer setThreadNum(int threadNum) {
        if (threadNum <= 1) {
            throw new InvalidParameterException("threadNum must >= 2");
        }
        this.config.setThreadNum(threadNum);
        return this;
    }

    public AioQuickServer setWriteBuffer(int bufferSize, int bufferCapacity) {
        this.config.setWriteBufferSize(bufferSize);
        this.config.setWriteBufferCapacity(bufferCapacity);
        return this;
    }

    public AioQuickServer setBacklog(int backlog) {
        this.config.setBacklog(backlog);
        return this;
    }

    public AioQuickServer setBufferPagePool(BufferPool bufferPool) {
        this.bufferPool = bufferPool;
        this.config.setBufferFactory(BufferFactory.DISABLED_BUFFER_FACTORY);
        return this;
    }

    public AioQuickServer setBufferFactory(BufferFactory bufferFactory) {
        this.config.setBufferFactory(bufferFactory);
        this.bufferPool = null;
        return this;
    }

    public AioQuickServer setReadBufferFactory(VirtualFactory readBufferFactory) {
        this.readBufferFactory = readBufferFactory;
        return this;
    }

    public AioQuickServer setLowMemory(boolean lowMemory) {
        this.config.setLowMemory(lowMemory);
        return this;
    }
}

