/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.socket.AioSession;
import org.aoju.bus.socket.Protocol;
import org.aoju.bus.socket.ServerConfig;
import org.aoju.bus.socket.TcpAioSession;
import org.aoju.bus.socket.buffers.BufferFactory;
import org.aoju.bus.socket.buffers.BufferPool;
import org.aoju.bus.socket.buffers.VirtualFactory;
import org.aoju.bus.socket.handler.ReadCompletionHandler;
import org.aoju.bus.socket.handler.WriteCompletionHandler;
import org.aoju.bus.socket.process.MessageProcessor;

public final class AioQuickClient {
    private final ServerConfig config = new ServerConfig();
    private TcpAioSession session;
    private BufferPool bufferPool = null;
    private BufferPool innerBufferPool = null;
    private AsynchronousChannelGroup asynchronousChannelGroup;
    private SocketAddress localAddress;
    private int connectTimeout;
    private VirtualFactory readBufferFactory = bufferPage -> bufferPage.allocate(this.config.getReadBufferSize());

    public <T> AioQuickClient(String host, int port, Protocol<T> protocol, MessageProcessor<T> messageProcessor) {
        this.config.setHost(host);
        this.config.setPort(port);
        this.config.setProtocol(protocol);
        this.config.setProcessor(messageProcessor);
    }

    public <A> void start(A attachment, CompletionHandler<AioSession, ? super A> handler) throws IOException {
        this.asynchronousChannelGroup = AsynchronousChannelGroup.withFixedThreadPool(2, Thread::new);
        this.start(this.asynchronousChannelGroup, attachment, handler);
    }

    public <A> void start(AsynchronousChannelGroup asynchronousChannelGroup, final A attachment, final CompletionHandler<AioSession, ? super A> handler) throws IOException {
        AsynchronousSocketChannel socketChannel = AsynchronousSocketChannel.open(asynchronousChannelGroup);
        if (this.bufferPool == null) {
            this.innerBufferPool = this.bufferPool = this.config.getBufferFactory().create();
        }
        if (this.config.getSocketOptions() != null) {
            for (Map.Entry<SocketOption<Object>, Object> entry : this.config.getSocketOptions().entrySet()) {
                socketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
            }
        }
        if (this.localAddress != null) {
            socketChannel.bind(this.localAddress);
        }
        socketChannel.connect(new InetSocketAddress(this.config.getHost(), this.config.getPort()), socketChannel, new CompletionHandler<Void, AsynchronousSocketChannel>(){
            final /* synthetic */ AioQuickClient this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void completed(Void result, AsynchronousSocketChannel socketChannel) {
                try {
                    AsynchronousSocketChannel connectedChannel = socketChannel;
                    if (this.this$0.config.getMonitor() != null) {
                        connectedChannel = this.this$0.config.getMonitor().shouldAccept(socketChannel);
                    }
                    if (connectedChannel == null) {
                        throw new RuntimeException("NetMonitor refuse channel");
                    }
                    this.this$0.session = new TcpAioSession(connectedChannel, this.this$0.config, new ReadCompletionHandler(), new WriteCompletionHandler(), this.this$0.bufferPool.allocateBufferPage(), () -> this.this$0.readBufferFactory.newBuffer(this.this$0.bufferPool.allocateBufferPage()));
                    handler.completed(this.this$0.session, attachment);
                }
                catch (Exception e) {
                    this.failed((Throwable)e, socketChannel);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(Throwable exc, AsynchronousSocketChannel socketChannel) {
                try {
                    handler.failed(exc, attachment);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (socketChannel != null) {
                        IoKit.close((AsynchronousSocketChannel)socketChannel);
                    }
                    this.this$0.shutdownNow();
                }
            }
        });
    }

    public AioSession start(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        CompletableFuture future = new CompletableFuture();
        this.start(asynchronousChannelGroup, future, new CompletionHandler<AioSession, CompletableFuture<AioSession>>(){

            @Override
            public void completed(AioSession session, CompletableFuture<AioSession> future) {
                if (future.isDone() || future.isCancelled()) {
                    session.close();
                } else {
                    future.complete(session);
                }
            }

            @Override
            public void failed(Throwable exc, CompletableFuture<AioSession> future) {
                future.completeExceptionally(exc);
            }
        });
        try {
            if (this.connectTimeout > 0) {
                return (AioSession)future.get(this.connectTimeout, TimeUnit.MILLISECONDS);
            }
            return (AioSession)future.get();
        }
        catch (Exception e) {
            future.cancel(false);
            this.shutdownNow();
            throw new IOException(e);
        }
    }

    public TcpAioSession getSession() {
        return this.session;
    }

    public final AioSession start() throws IOException {
        this.asynchronousChannelGroup = AsynchronousChannelGroup.withFixedThreadPool(2, Thread::new);
        return this.start(this.asynchronousChannelGroup);
    }

    public final void shutdown() {
        this.shutdown0(false);
    }

    public final void shutdownNow() {
        this.shutdown0(true);
    }

    private void shutdown0(boolean flag) {
        if (this.session != null) {
            this.session.close(flag);
            this.session = null;
        }
        if (this.asynchronousChannelGroup != null) {
            this.asynchronousChannelGroup.shutdown();
            this.asynchronousChannelGroup = null;
        }
        if (this.innerBufferPool != null) {
            this.innerBufferPool.release();
            this.innerBufferPool = null;
            this.bufferPool = null;
        }
    }

    public final AioQuickClient setReadBufferSize(int size) {
        this.config.setReadBufferSize(size);
        return this;
    }

    public final <V> AioQuickClient setOption(SocketOption<V> socketOption, V value) {
        this.config.setOption(socketOption, value);
        return this;
    }

    public final AioQuickClient bindLocal(String local, int port) {
        this.localAddress = local == null ? new InetSocketAddress(port) : new InetSocketAddress(local, port);
        return this;
    }

    public final AioQuickClient setBufferPagePool(BufferPool bufferPool) {
        this.bufferPool = bufferPool;
        this.config.setBufferFactory(BufferFactory.DISABLED_BUFFER_FACTORY);
        return this;
    }

    public final AioQuickClient setBufferFactory(BufferFactory bufferFactory) {
        this.config.setBufferFactory(bufferFactory);
        this.bufferPool = null;
        return this;
    }

    public final AioQuickClient setWriteBuffer(int bufferSize, int bufferCapacity) {
        this.config.setWriteBufferSize(bufferSize);
        this.config.setWriteBufferCapacity(bufferCapacity);
        return this;
    }

    public final AioQuickClient connectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public final AioQuickClient setReadBufferFactory(VirtualFactory readBufferFactory) {
        this.readBufferFactory = readBufferFactory;
        return this;
    }
}

