/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.handler;

import java.nio.channels.CompletionHandler;
import org.aoju.bus.socket.NetMonitor;
import org.aoju.bus.socket.SocketStatus;
import org.aoju.bus.socket.TcpAioSession;

public class WriteCompletionHandler
implements CompletionHandler<Integer, TcpAioSession> {
    @Override
    public void completed(Integer result, TcpAioSession aioSession) {
        try {
            NetMonitor monitor = aioSession.getServerConfig().getMonitor();
            if (monitor != null) {
                monitor.afterWrite(aioSession, result);
            }
            aioSession.writeCompleted();
        }
        catch (Exception e) {
            this.failed((Throwable)e, aioSession);
        }
    }

    @Override
    public void failed(Throwable exc, TcpAioSession aioSession) {
        try {
            aioSession.getServerConfig().getProcessor().stateEvent(aioSession, SocketStatus.OUTPUT_EXCEPTION, exc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            aioSession.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

