/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.crypto.advice;

import java.io.InputStream;
import java.lang.reflect.Type;
import org.aoju.bus.base.spring.BaseAdvice;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.crypto.Mode;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.spring.crypto.CryptoProperties;
import org.aoju.bus.spring.crypto.annotation.CryptoD;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.converter.HttpMessageConverter;

public class RequestBodyAdvice
extends BaseAdvice
implements org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice {
    @Autowired
    private CryptoProperties cryptoProperties;

    public boolean supports(MethodParameter parameter, Type type, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public org.springframework.http.HttpInputMessage beforeBodyRead(org.springframework.http.HttpInputMessage inputMessage, MethodParameter parameter, Type type, Class<? extends HttpMessageConverter<?>> converterType) {
        if (!this.cryptoProperties.isDebug()) {
            try {
                CryptoD decrypt = parameter.getMethod().getAnnotation(CryptoD.class);
                if (ObjectUtils.isNotNull((Object)decrypt)) {
                    String key = StringUtils.defaultString((String)decrypt.key(), (String)this.cryptoProperties.getDecrypt().getKey());
                    return new HttpInputMessage(inputMessage, key, decrypt.type(), "UTF-8");
                }
            }
            catch (Exception e) {
                Logger.error((String)"\u6570\u636e\u89e3\u5bc6\u5931\u8d25", (Object[])new Object[]{e});
            }
        }
        return inputMessage;
    }

    public Object afterBodyRead(Object body, org.springframework.http.HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public Object handleEmptyBody(Object body, org.springframework.http.HttpInputMessage inputMessage, MethodParameter parameter, Type type, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    class HttpInputMessage
    implements org.springframework.http.HttpInputMessage {
        private HttpHeaders headers;
        private InputStream body;

        public HttpInputMessage(org.springframework.http.HttpInputMessage inputMessage, String key, Mode mode, String charset) throws Exception {
            String decryptBody;
            if (StringUtils.isEmpty((Object)key)) {
                throw new NullPointerException("\u8bf7\u914d\u7f6espring.decrypt.key\u53c2\u6570");
            }
            this.headers = inputMessage.getHeaders();
            String content = IoUtils.toString((InputStream)inputMessage.getBody(), (String)charset);
            if (content.startsWith("{")) {
                decryptBody = content;
            } else {
                StringBuilder json = new StringBuilder();
                if (!StringUtils.isEmpty((Object)(content = content.replaceAll(" ", "+")))) {
                    String[] contents = content.split("\\|");
                    for (int k = 0; k < contents.length; ++k) {
                        String value = contents[k];
                        value = new String(CryptoUtils.decrypt((Mode)mode, (String)key, (byte[])Base64.decode((String)value)), charset);
                        json.append(value);
                    }
                }
                decryptBody = json.toString();
            }
            this.body = IoUtils.toInputStream((String)decryptBody, (String)charset);
        }

        public InputStream getBody() {
            return this.body;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }
    }
}

