/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.crypto.advice;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.aoju.bus.base.spring.BaseAdvice;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.crypto.Mode;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.spring.crypto.CryptoProperties;
import org.aoju.bus.spring.crypto.annotation.CryptoE;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;

public class ResponseBodyAdvice
extends BaseAdvice
implements org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice<Object> {
    @Autowired
    private CryptoProperties cryptoProperties;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter parameter, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (!this.cryptoProperties.isDebug()) {
            try {
                CryptoE encrypt = parameter.getMethod().getAnnotation(CryptoE.class);
                if (ObjectUtils.isNotNull((Object)encrypt)) {
                    String key = StringUtils.defaultString((String)encrypt.key(), (String)this.cryptoProperties.getDecrypt().getKey());
                    if (!StringUtils.hasText((String)key)) {
                        throw new NullPointerException("\u8bf7\u914d\u7f6espring.encrypt.key\u53c2\u6570");
                    }
                    String content = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(body);
                    byte[] data = content.getBytes();
                    byte[] encodedData = CryptoUtils.encrypt((Mode)encrypt.type(), (String)key, (byte[])data);
                    return Base64.encode((byte[])encodedData);
                }
            }
            catch (Exception e) {
                Logger.error((String)"\u52a0\u5bc6\u6570\u636e\u5f02\u5e38", (Object[])new Object[]{e.getMessage()});
            }
        }
        return body;
    }
}

