/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.mapper;

import java.util.Properties;
import javax.sql.DataSource;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.pager.plugin.PageInterceptor;
import org.aoju.bus.spring.mapper.MybatisProperties;
import org.aoju.bus.spring.mapper.PerformanceHandler;
import org.aoju.bus.spring.mapper.SQLExplainHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@EnableConfigurationProperties(value={MybatisProperties.class})
public class MybatisConfiguration {
    @Autowired
    MybatisProperties properties;

    @Bean
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource) {
        try {
            SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
            bean.setDataSource(dataSource);
            if (StringUtils.isNotBlank((CharSequence)this.properties.getTypeAliasesPackage())) {
                bean.setTypeAliasesPackage(this.properties.getTypeAliasesPackage());
            }
            PageInterceptor interceptor = new PageInterceptor();
            Properties properties = new Properties();
            properties.setProperty("autoDelimitKeywords", this.properties.getAutoDelimitKeywords());
            properties.setProperty("reasonable", this.properties.getReasonable());
            properties.setProperty("supportMethodsArguments", this.properties.getSupportMethodsArguments());
            properties.setProperty("returnPageInfo", this.properties.getReturnPageInfo());
            properties.setProperty("params", this.properties.getParams());
            interceptor.setProperties(properties);
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Interceptor[] plugins = new Interceptor[]{interceptor, new PerformanceHandler(), new SQLExplainHandler()};
            bean.setPlugins(plugins);
            bean.setMapperLocations(resolver.getResources(this.properties.getXmlLocation()));
            return bean.getObject();
        }
        catch (Exception e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    @Bean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

