/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.druid;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.spring.druid.DruidMonitorProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={DruidDataSource.class})
@EnableConfigurationProperties(value={DruidMonitorProperties.class})
@ConditionalOnProperty(prefix="spring.druid.monitor", havingValue="enabled", value={"enabled"})
@AutoConfigureAfter(value={DataSource.class})
public class DruidMonitorConfiguration {
    @Autowired
    private DruidMonitorProperties properties;

    @Bean
    public ServletRegistrationBean druidStatViewServlet() {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[]{this.properties.getDruidStatView()});
        servletRegistrationBean.addInitParameter("allow", this.properties.getAllow());
        Logger.info((String)("allow ---> " + this.properties.getAllow()), (Object[])new Object[0]);
        servletRegistrationBean.addInitParameter("deny", this.properties.getDeny());
        Logger.info((String)("deny ---> " + this.properties.getDeny()), (Object[])new Object[0]);
        servletRegistrationBean.addInitParameter("loginUsername", this.properties.getLoginUsername());
        servletRegistrationBean.addInitParameter("loginPassword", this.properties.getLoginPassword());
        Logger.info((String)("username ---> " + this.properties.getLoginUsername() + " password ---> " + this.properties.getLoginPassword()), (Object[])new Object[0]);
        servletRegistrationBean.addInitParameter("resetEnable", this.properties.getResetEnable());
        Logger.info((String)("resetEnable ---> " + this.properties.getResetEnable()), (Object[])new Object[0]);
        return servletRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean druidStatFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new WebStatFilter(), new ServletRegistrationBean[0]);
        filterRegistrationBean.addUrlPatterns(new String[]{this.properties.getDruidWebStatFilter()});
        Logger.info((String)("urlPatterns ---> " + this.properties.getDruidWebStatFilter()), (Object[])new Object[0]);
        filterRegistrationBean.addInitParameter("exclusions", this.properties.getExclusions());
        Logger.info((String)("exclusions ---> " + this.properties.getExclusions()), (Object[])new Object[0]);
        return filterRegistrationBean;
    }
}

