/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.druid;

import com.alibaba.druid.pool.DruidDataSource;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.spring.druid.DruidProperties;
import org.aoju.bus.spring.druid.MultiDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@ConditionalOnClass(value={DruidDataSource.class})
@EnableConfigurationProperties(value={DruidProperties.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
public class DruidConfiguration {
    private static final ConfigurationPropertyNameAliases aliases = new ConfigurationPropertyNameAliases();
    @Autowired
    DruidProperties druidProperties;
    private Map<Object, Object> sourceMap = new HashMap<Object, Object>();

    @Bean
    @Primary
    public MultiDataSource dataSource() {
        Map<String, Object> defaultConfig = this.beanToMap(this.druidProperties);
        DataSource defaultDatasource = this.bind(defaultConfig);
        this.sourceMap.put("dataSource", defaultDatasource);
        if (ObjectUtils.isNotEmpty((Object[])new Object[]{this.druidProperties.getMulti()})) {
            Logger.info((String)"Enabled Multiple DataSource", (Object[])new Object[0]);
            List<DruidProperties> list = this.druidProperties.getMulti();
            for (int i = 0; i < list.size(); ++i) {
                Map<String, Object> config = this.beanToMap(list.get(i));
                if (((Boolean)config.getOrDefault("extend", Boolean.TRUE)).booleanValue()) {
                    HashMap<String, Object> properties = new HashMap<String, Object>(defaultConfig);
                    properties.putAll(config);
                }
                this.sourceMap.put(config.get("key").toString(), this.bind(config));
            }
        }
        MultiDataSource dataSource = new MultiDataSource();
        dataSource.setDefaultTargetDataSource(defaultDatasource);
        dataSource.setTargetDataSources(this.sourceMap);
        return dataSource;
    }

    @Bean
    public DataSourceTransactionManager transactionManager(DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    private DataSource bind(Map<String, Object> map) {
        String type = StringUtils.toString((Object)map.get("type"));
        try {
            if (!StringUtils.isEmpty((Object)type)) {
                Class<?> dataSourceType = Class.forName(type);
                DataSourceBuilder factory = DataSourceBuilder.create().driverClassName((String)map.get("driverClassName")).url((String)map.get("url")).username(StringUtils.toString((Object)map.get("username"))).password(StringUtils.toString((Object)map.get("password"))).type(dataSourceType);
                return factory.build();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can not resolve class with type: " + type);
        }
        return null;
    }

    private <T> Map<String, Object> beanToMap(T bean) {
        HashMap map = Maps.newHashMap();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                if ("driverClassName".equals(key)) {
                    key = "driver-class-name";
                }
                Object value = beanMap.get(key);
                if (StringUtils.isNotEmpty((String)this.druidProperties.getPrivateKey())) {
                    if ("url".equals(key)) {
                        value = CryptoUtils.decrypt((String)"AES", (String)this.druidProperties.getPrivateKey(), (String)value.toString(), (java.nio.charset.Charset)Charset.UTF_8);
                        beanMap.put((Object)"url", value);
                    } else if ("username".equals(key)) {
                        value = CryptoUtils.decrypt((String)"AES", (String)this.druidProperties.getPrivateKey(), (String)value.toString(), (java.nio.charset.Charset)Charset.UTF_8);
                        beanMap.put((Object)"username", value);
                    } else if ("password".equals(key)) {
                        value = CryptoUtils.decrypt((String)"AES", (String)this.druidProperties.getPrivateKey(), (String)value.toString(), (java.nio.charset.Charset)Charset.UTF_8);
                        beanMap.put((Object)"password", value);
                    }
                }
                map.put(key + "", value);
            }
        }
        return map;
    }

    static {
        aliases.addAliases("url", new String[]{"jdbc-url"});
        aliases.addAliases("username", new String[]{"user"});
    }
}

