/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.storage;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.aoju.bus.spring.storage.StorageProperties;
import org.aoju.bus.storage.StorageProvider;
import org.aoju.bus.storage.UploadObject;
import org.aoju.bus.storage.UploadToken;
import org.aoju.bus.storage.provider.fdfs.FdfsProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={StorageProperties.class})
public class StorageConfiguration {
    @Autowired
    StorageProperties properties;
    @Autowired
    StorageProvider storageProvider;

    @Bean
    public void afterPropertiesSet() {
        if (!"fastDFS".equals(this.properties.getProvider())) {
            throw new RuntimeException("Provider[" + this.properties.getProvider() + "] not core");
        }
        Properties properties = new Properties();
        this.storageProvider = new FdfsProvider(this.properties.getGroupName(), properties);
    }

    public String upload(String fileName, File file) {
        return this.storageProvider.upload(new UploadObject(fileName, file));
    }

    public String upload(String fileName, InputStream in, String mimeType) {
        return this.storageProvider.upload(new UploadObject(fileName, in, mimeType));
    }

    public boolean delete(String fileName) {
        return this.storageProvider.delete(fileName);
    }

    public Map<String, Object> createUploadToken(UploadToken param) {
        return this.storageProvider.createUploadToken(param);
    }
}

