/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringContextAware
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    private static void isApplicationContext() {
        if (applicationContext == null) {
            throw new IllegalStateException("\u8bf7\u914d\u7f6e\u6ce8\u89e3\u626b\u63cf,\u6216\u8005\u5b9a\u4e49SpringContextAware");
        }
    }

    public static ApplicationContext getApplicationContext() {
        SpringContextAware.isApplicationContext();
        return applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        System.setProperty("user.timezone", "Asia/Shanghai");
        SpringContextAware.applicationContext = applicationContext;
    }

    public static <T> T getBean(String name) {
        SpringContextAware.isApplicationContext();
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        SpringContextAware.isApplicationContext();
        Map beanMaps = applicationContext.getBeansOfType(clazz);
        if (beanMaps != null && !beanMaps.isEmpty()) {
            return (T)beanMaps.values().iterator().next();
        }
        return null;
    }

    public static <T> Map<String, T> getBeanOfType(Class<T> requiredType) throws BeansException {
        SpringContextAware.isApplicationContext();
        return applicationContext.getBeansOfType(requiredType);
    }

    public static Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annType) {
        SpringContextAware.isApplicationContext();
        return applicationContext.getBeansWithAnnotation(annType);
    }

    public static String getActiveProfile() {
        SpringContextAware.isApplicationContext();
        return applicationContext.getEnvironment().getActiveProfiles()[0];
    }

    public static boolean isDemoMode() {
        return SpringContextAware.isTestMode() || SpringContextAware.isDevMode();
    }

    public static boolean isDevMode() {
        return "dev".equalsIgnoreCase(SpringContextAware.getActiveProfile());
    }

    public static boolean isTestMode() {
        return "test".equalsIgnoreCase(SpringContextAware.getActiveProfile());
    }
}

