/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.core.selector;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.logger.Logger;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;

public abstract class AbstractImportSelector<T>
implements DeferredImportSelector,
BeanClassLoaderAware,
EnvironmentAware {
    private ClassLoader beanClassLoader;
    private Class<T> annotationClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractImportSelector.class);
    private Environment environment;

    protected AbstractImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata metadata) {
        if (!this.isEnabled()) {
            return new String[0];
        }
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(this.annotationClass.getName(), true));
        Assert.notNull((Object)attributes, (String)("No " + this.getSimpleName() + " attributes found. Is " + metadata.getClassName() + " annotated with @" + this.getSimpleName() + "?"), (Object[])new Object[0]);
        ArrayList factories = new ArrayList(new LinkedHashSet(SpringFactoriesLoader.loadFactoryNames(this.annotationClass, (ClassLoader)this.beanClassLoader)));
        if (factories.isEmpty() && !this.hasDefaultFactory()) {
            throw new IllegalStateException("Annotation @" + this.getSimpleName() + " found, but there are no implementations. Did you forget to include a starter?");
        }
        if (factories.size() > 1) {
            Logger.warn((String)("More than first implementation of @" + this.getSimpleName() + " (now relying on @Conditionals to pick first): " + factories), (Object[])new Object[0]);
        }
        return factories.toArray(new String[factories.size()]);
    }

    protected boolean hasDefaultFactory() {
        return false;
    }

    protected String getSimpleName() {
        return this.annotationClass.getSimpleName();
    }

    protected Class<T> getAnnotationClass() {
        return this.annotationClass;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected abstract boolean isEnabled();
}

