/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.spring.servlet.BodyCacheHttpServletRequestWrapper;
import org.aoju.bus.spring.servlet.BodyCacheHttpServletResponseWrapper;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class RequestLoggingHandler
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String method = request.getMethod();
        if ((HttpMethod.POST.matches(method) || HttpMethod.PATCH.matches(method) || HttpMethod.PUT.matches(method)) && request instanceof BodyCacheHttpServletRequestWrapper) {
            BodyCacheHttpServletRequestWrapper requestWrapper = (BodyCacheHttpServletRequestWrapper)request;
            Logger.info((String)"[\u8bf7\u6c42] - [{}]", (Object[])new Object[]{new String(requestWrapper.getBody())});
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        String method = request.getMethod();
        if ((HttpMethod.POST.matches(method) || HttpMethod.PATCH.matches(method) || HttpMethod.PUT.matches(method)) && response instanceof BodyCacheHttpServletResponseWrapper) {
            BodyCacheHttpServletResponseWrapper responseWrapper = (BodyCacheHttpServletResponseWrapper)response;
            Logger.info((String)"[\u8bf7\u6c42] - [{}]", (Object[])new Object[]{new String(responseWrapper.getBody())});
        }
    }
}

