/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.sensitive;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.sensitive.Builder;
import org.aoju.bus.sensitive.Provider;
import org.aoju.bus.sensitive.annotation.JSON;
import org.aoju.bus.sensitive.annotation.Privacy;
import org.aoju.bus.sensitive.annotation.Sensitive;
import org.aoju.bus.spring.crypto.CryptoProperties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.springframework.beans.factory.annotation.Autowired;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class SensitiveStatementHandler
implements Interceptor {
    private static final String MAPPEDSTATEMENT = "delegate.mappedStatement";
    private static final String BOUND_SQL = "delegate.boundSql";
    @Autowired
    CryptoProperties cryptoProperties;

    public Object intercept(Invocation invocation) throws Throwable {
        Sensitive enableSensitive;
        StatementHandler statementHandler = (StatementHandler)Provider.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue(MAPPEDSTATEMENT);
        SqlCommandType commandType = mappedStatement.getSqlCommandType();
        BoundSql boundSql = (BoundSql)metaObject.getValue(BOUND_SQL);
        Object params = boundSql.getParameterObject();
        if (params instanceof Map) {
            return invocation.proceed();
        }
        Sensitive sensitive = enableSensitive = params != null ? params.getClass().getAnnotation(Sensitive.class) : null;
        if (ObjectUtils.isNotEmpty((Object[])new Object[]{enableSensitive})) {
            this.handleParameters(mappedStatement.getConfiguration(), boundSql, params, commandType);
        }
        return invocation.proceed();
    }

    private void handleParameters(Configuration configuration, BoundSql boundSql, Object param, SqlCommandType commandType) {
        HashMap<String, Object> newValues = new HashMap<String, Object>(16);
        MetaObject metaObject = configuration.newMetaObject(param);
        for (Field field : param.getClass().getDeclaredFields()) {
            Object value;
            Object newValue = value = metaObject.getValue(field.getName());
            if (value instanceof CharSequence) {
                newValue = this.handlePrivacy(field, newValue);
                if (this.isWriteCommand(commandType) && !Provider.alreadyBeSentisived((Object)newValue)) {
                    newValue = this.handleSensitiveField(field, newValue);
                    newValue = this.handleSensitiveJSONField(field, newValue);
                }
            }
            if (value == null || newValue == null || value.equals(newValue)) continue;
            newValues.put(field.getName(), newValue);
        }
        for (Map.Entry entry : newValues.entrySet()) {
            boundSql.setAdditionalParameter((String)entry.getKey(), entry.getValue());
        }
    }

    private boolean isWriteCommand(SqlCommandType commandType) {
        return SqlCommandType.UPDATE.equals((Object)commandType) || SqlCommandType.INSERT.equals((Object)commandType);
    }

    private Object handlePrivacy(Field field, Object value) {
        Privacy privacy = field.getAnnotation(Privacy.class);
        Object newValue = value;
        if (ObjectUtils.isNotEmpty((Object[])new Object[]{privacy}) && value != null) {
            newValue = Base64.encode((byte[])CryptoUtils.encrypt((String)"SHA1withRSA", null, (byte[])value.toString().getBytes()));
        }
        return newValue;
    }

    private Object handleSensitiveField(Field field, Object value) {
        org.aoju.bus.sensitive.annotation.Field sensitiveField = field.getAnnotation(org.aoju.bus.sensitive.annotation.Field.class);
        Object newValue = value;
        if (sensitiveField != null && value != null) {
            newValue = Builder.on((Object)value);
        }
        return newValue;
    }

    private Object handleSensitiveJSONField(Field field, Object value) {
        JSON sensitiveJSONField = field.getAnnotation(JSON.class);
        Object newValue = value;
        if (sensitiveJSONField != null && value != null) {
            newValue = this.processJsonField(newValue, sensitiveJSONField);
        }
        return newValue;
    }

    private Object processJsonField(Object newValue, JSON json) {
        try {
            org.aoju.bus.sensitive.annotation.Field[] keys;
            Map map = Provider.parseToObjectMap((String)newValue.toString());
            for (org.aoju.bus.sensitive.annotation.Field field : keys = json.value()) {
                String key = field.key();
                Object oldData = map.get(key);
                if (oldData == null) continue;
                String newData = (String)Builder.on(oldData);
                map.put(key, newData);
            }
            return Provider.parseMaptoJSONString((Map)map);
        }
        catch (Throwable e) {
            return newValue;
        }
    }

    public Object plugin(Object o) {
        return Plugin.wrap((Object)o, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

