/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.crypto;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import org.aoju.bus.base.spring.BaseAdvice;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.crypto.annotation.EncryptBody;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.spring.crypto.CryptoProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;

public class ResponseBodyAdvice
extends BaseAdvice
implements org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice<Object> {
    @Autowired
    CryptoProperties properties;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        Annotation[] annotations = returnType.getDeclaringClass().getAnnotations();
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof EncryptBody)) continue;
                return true;
            }
        }
        return returnType.getMethod().isAnnotationPresent(EncryptBody.class);
    }

    public Object beforeBodyWrite(Object body, MethodParameter parameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> converterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (!this.properties.isDebug()) {
            try {
                EncryptBody encrypt = parameter.getMethod().getAnnotation(EncryptBody.class);
                if (ObjectUtils.isNotNull((Object)encrypt)) {
                    String encryptKey = StringUtils.defaultString((String)encrypt.key(), (String)this.properties.getDecrypt().getKey());
                    String encryptType = StringUtils.defaultString((String)encrypt.type(), (String)this.properties.getDecrypt().getType());
                    if (!StringUtils.hasText((String)encryptKey)) {
                        throw new NullPointerException("please check the request.crypto.encrypt.key");
                    }
                    String content = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(body);
                    content = CryptoUtils.encrypt((String)encryptType, (String)encryptKey, (String)content, (java.nio.charset.Charset)Charset.UTF_8);
                    return Base64.encode((String)content);
                }
            }
            catch (Exception e) {
                Logger.error((String)("\u52a0\u5bc6\u6570\u636e\u5f02\u5e38:" + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return body;
    }
}

