/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.sensitive;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.sensitive.Builder;
import org.aoju.bus.sensitive.annotation.Privacy;
import org.aoju.bus.sensitive.annotation.Sensitive;
import org.aoju.bus.spring.SpringContextAware;
import org.aoju.bus.spring.sensitive.SensitiveProperties;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class SensitiveResultSetHandler
implements Interceptor {
    private static final String MAPPED_STATEMENT = "mappedStatement";

    public Object intercept(Invocation invocation) throws Throwable {
        List results = (List)invocation.proceed();
        if (results.isEmpty()) {
            return results;
        }
        SensitiveProperties properties = SpringContextAware.getBean(SensitiveProperties.class);
        if (!properties.isDebug()) {
            ResultSetHandler statementHandler = (ResultSetHandler)SensitiveResultSetHandler.realTarget(invocation.getTarget());
            MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
            MappedStatement mappedStatement = (MappedStatement)metaObject.getValue(MAPPED_STATEMENT);
            ResultMap resultMap = mappedStatement.getResultMaps().isEmpty() ? null : (ResultMap)mappedStatement.getResultMaps().get(0);
            Object result0 = results.get(0);
            Sensitive enableSensitive = result0.getClass().getAnnotation(Sensitive.class);
            if (enableSensitive == null) {
                return results;
            }
            Map<String, Privacy> sensitiveFieldMap = this.getSensitiveByResultMap(resultMap);
            Map<String, org.aoju.bus.sensitive.annotation.Field> sensitiveBindedMap = this.getSensitiveBindedByResultMap(resultMap);
            if (sensitiveBindedMap.isEmpty() && sensitiveFieldMap.isEmpty()) {
                return results;
            }
            for (Object obj : results) {
                MetaObject objMetaObject = mappedStatement.getConfiguration().newMetaObject(obj);
                for (Map.Entry<String, Privacy> entry : sensitiveFieldMap.entrySet()) {
                    String property;
                    String value;
                    Privacy privacy = entry.getValue();
                    if (!ObjectUtils.isNotNull((Object)privacy) || !StringUtils.isNotEmpty((String)privacy.value()) || !"ALL".equals(privacy.value()) && !"OUT".equals(privacy.value()) || !StringUtils.isNotEmpty((String)(value = (String)objMetaObject.getValue(property = entry.getKey())))) continue;
                    if (ObjectUtils.isEmpty((Object[])new Object[]{properties})) {
                        throw new InstrumentException("please check the request.crypto.decrypt");
                    }
                    String decryptValue = CryptoUtils.decrypt((String)properties.getDecrypt().getType(), (String)properties.getDecrypt().getKey(), (String)value, (java.nio.charset.Charset)Charset.UTF_8);
                    objMetaObject.setValue(property, (Object)decryptValue);
                }
                Builder.on(obj);
            }
        }
        return results;
    }

    public Object plugin(Object o) {
        return Plugin.wrap((Object)o, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private Map<String, org.aoju.bus.sensitive.annotation.Field> getSensitiveBindedByResultMap(ResultMap resultMap) {
        if (resultMap == null) {
            return new HashMap<String, org.aoju.bus.sensitive.annotation.Field>(16);
        }
        HashMap<String, org.aoju.bus.sensitive.annotation.Field> sensitiveBindedMap = new HashMap<String, org.aoju.bus.sensitive.annotation.Field>(16);
        Class clazz = resultMap.getType();
        for (Field field : clazz.getDeclaredFields()) {
            org.aoju.bus.sensitive.annotation.Field sensitiveBind = field.getAnnotation(org.aoju.bus.sensitive.annotation.Field.class);
            if (sensitiveBind == null) continue;
            sensitiveBindedMap.put(field.getName(), sensitiveBind);
        }
        return sensitiveBindedMap;
    }

    private Map<String, Privacy> getSensitiveByResultMap(ResultMap resultMap) {
        if (resultMap == null) {
            return new HashMap<String, Privacy>(16);
        }
        return this.getSensitiveByType(resultMap.getType());
    }

    private Map<String, Privacy> getSensitiveByType(Class<?> clazz) {
        HashMap<String, Privacy> sensitiveFieldMap = new HashMap<String, Privacy>(16);
        for (Field field : clazz.getDeclaredFields()) {
            Privacy sensitiveField = field.getAnnotation(Privacy.class);
            if (sensitiveField == null) continue;
            sensitiveFieldMap.put(field.getName(), sensitiveField);
        }
        return sensitiveFieldMap;
    }

    private static <T> T realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return SensitiveResultSetHandler.realTarget(metaObject.getValue("hi.target"));
        }
        return (T)target;
    }
}

