/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.druid;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Set;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.spring.druid.DataSource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.stereotype.Component;

public class MultiDataSource
extends AbstractRoutingDataSource {
    private static final ThreadLocal<String> DATA_SOURCE_KEY = new ThreadLocal();
    private Set<Object> keySet;

    private static void add(String key) {
        DATA_SOURCE_KEY.set(key);
    }

    private static void clear() {
        DATA_SOURCE_KEY.remove();
    }

    protected Object determineCurrentLookupKey() {
        String key = DATA_SOURCE_KEY.get();
        if (this.keySet.contains(key)) {
            Logger.info((String)"this session may use dataSource by key: {}", (Object[])new Object[]{key});
        }
        return key;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        try {
            Field sourceMapField = AbstractRoutingDataSource.class.getDeclaredField("resolvedDataSources");
            sourceMapField.setAccessible(true);
            Map sourceMap = (Map)sourceMapField.get((Object)this);
            this.keySet = sourceMap.keySet();
            sourceMapField.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    @Order(value=-1)
    @Aspect
    @Component
    public static class DataSourceSwitchInterceptor {
        @Pointcut(value="@annotation(org.aoju.bus.spring.druid.DataSource)")
        public void switching() {
            Logger.info((String)"switch dataSource", (Object[])new Object[0]);
        }

        @Around(value="switching()")
        public Object switchByMethod(ProceedingJoinPoint point) throws Throwable {
            Method method = this.getMethodByPoint(point);
            Parameter[] params = method.getParameters();
            String source = null;
            boolean isDynamic = false;
            for (int i = params.length - 1; i >= 0; --i) {
                Parameter parameter = params[i];
                if (parameter.getAnnotation(DataSource.class) == null || !(point.getArgs()[i] instanceof String)) continue;
                source = (String)point.getArgs()[i];
                isDynamic = true;
                break;
            }
            if (!isDynamic) {
                DataSource dataSource = method.getAnnotation(DataSource.class);
                if (null == dataSource || !StringUtils.hasLength((String)dataSource.value())) {
                    dataSource = method.getDeclaringClass().getAnnotation(DataSource.class);
                }
                if (null != dataSource) {
                    source = dataSource.value();
                }
            }
            return this.keepOnByByPoint(source, point);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object keepOnByByPoint(String source, ProceedingJoinPoint point) throws Throwable {
            try {
                MultiDataSource.add(source);
                Object object = point.proceed();
                return object;
            }
            finally {
                MultiDataSource.clear();
            }
        }

        private Method getMethodByPoint(ProceedingJoinPoint point) {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            return methodSignature.getMethod();
        }
    }
}

