/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.core.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.spring.core.proxy.mode.ProxyMode;
import org.aoju.bus.spring.core.proxy.mode.ScanMode;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;

public abstract class AbstractAutoScanProxy
extends AbstractAutoProxyCreator {
    public static final String CGLIB = "Cglib";
    public static final String PROXY_TYPE_REFLECTIVE = "Reflective Aop Proxy";
    public static final String PROXY_TYPE_CGLIB = "Cglib Aop Proxy";
    public static final String JDK_PROXY_NAME_KEY = "com.sun.proxy";
    public static final String CGLIB_PROXY_NAME_KEY = "ByCGLIB";
    public static final String SEPARATOR = ";";
    private static final long serialVersionUID = 6827218905375993727L;
    private final Map<String, Object> beanMap = new HashMap<String, Object>();
    private final Map<String, Boolean> proxyMap = new HashMap<String, Boolean>();
    private final Map<String, Boolean> proxyTargetClassMap = new HashMap<String, Boolean>();
    private String[] scanPackages;
    private ProxyMode proxyMode;
    private ScanMode scanMode;

    public AbstractAutoScanProxy() {
        this((String[])null);
    }

    public AbstractAutoScanProxy(String scanPackages) {
        this(scanPackages, ProxyMode.BY_CLASS_OR_METHOD_ANNOTATION, ScanMode.FOR_CLASS_OR_METHOD_ANNOTATION);
    }

    public AbstractAutoScanProxy(String[] scanPackages) {
        this(scanPackages, ProxyMode.BY_CLASS_OR_METHOD_ANNOTATION, ScanMode.FOR_CLASS_OR_METHOD_ANNOTATION);
    }

    public AbstractAutoScanProxy(ProxyMode proxyMode, ScanMode scanMode) {
        this((String[])null, proxyMode, scanMode);
    }

    public AbstractAutoScanProxy(String scanPackages, ProxyMode proxyMode, ScanMode scanMode) {
        this(scanPackages, proxyMode, scanMode, true);
    }

    public AbstractAutoScanProxy(String[] scanPackages, ProxyMode proxyMode, ScanMode scanMode) {
        this(scanPackages, proxyMode, scanMode, true);
    }

    public AbstractAutoScanProxy(ProxyMode proxyMode, ScanMode scanMode, boolean exposeProxy) {
        this((String[])null, proxyMode, scanMode, exposeProxy);
    }

    public AbstractAutoScanProxy(String scanPackages, ProxyMode proxyMode, ScanMode scanMode, boolean exposeProxy) {
        this(StringUtils.isNotEmpty((String)scanPackages) ? scanPackages.trim().split(SEPARATOR) : null, proxyMode, scanMode, exposeProxy);
    }

    public AbstractAutoScanProxy(String[] scanPackages, ProxyMode proxyMode, ScanMode scanMode, boolean exposeProxy) {
        this.scanPackages = scanPackages;
        this.setExposeProxy(exposeProxy);
        this.proxyMode = proxyMode;
        this.scanMode = scanMode;
        StringBuilder builder = new StringBuilder();
        if (ArrayUtils.isNotEmpty((Object[])scanPackages)) {
            for (int i = 0; i < scanPackages.length; ++i) {
                String scanPackage = scanPackages[i];
                builder.append(scanPackage);
                if (i >= scanPackages.length - 1) continue;
                builder.append(SEPARATOR);
            }
        }
        Logger.info((String)"------------- Aop Information ------------", (Object[])new Object[0]);
        Logger.info((String)"Auto scan proxy class is {}", (Object[])new Object[]{((Object)((Object)this)).getClass().getCanonicalName()});
        Logger.info((String)"Scan packages is {}", (Object[])new Object[]{ArrayUtils.isNotEmpty((Object[])scanPackages) ? builder.toString() : "not set"});
        Logger.info((String)"Proxy mode is {}", (Object[])new Object[]{proxyMode});
        Logger.info((String)"Scan mode is {}", (Object[])new Object[]{scanMode});
        Logger.info((String)"Expose proxy is {}", (Object[])new Object[]{exposeProxy});
        Logger.info((String)"-------------------------------------------------", (Object[])new Object[0]);
        Class<? extends MethodInterceptor>[] commonInterceptorClasses = this.getCommonInterceptors();
        Object[] commonInterceptorNames = this.getCommonInterceptorNames();
        Object[] interceptorNames = (String[])ArrayUtils.addAll((Object[])commonInterceptorNames, (Object[])this.convertInterceptorNames(commonInterceptorClasses));
        if (ArrayUtils.isNotEmpty((Object[])interceptorNames)) {
            this.setInterceptorNames((String[])interceptorNames);
        }
    }

    private String[] convertInterceptorNames(Class<? extends MethodInterceptor>[] commonInterceptorClasses) {
        if (ArrayUtils.isNotEmpty((Object[])commonInterceptorClasses)) {
            String[] interceptorNames = new String[commonInterceptorClasses.length];
            for (int i = 0; i < commonInterceptorClasses.length; ++i) {
                Class<? extends MethodInterceptor> interceptorClass = commonInterceptorClasses[i];
                interceptorNames[i] = interceptorClass.getAnnotation(Component.class).value();
            }
            return interceptorNames;
        }
        return null;
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class<?> beanClass, String beanName, TargetSource targetSource) {
        boolean scanPackagesContained;
        boolean scanPackagesEnabled = this.scanPackagesEnabled();
        if (scanPackagesEnabled && !(scanPackagesContained = this.scanPackagesContained(beanClass))) {
            return DO_NOT_PROXY;
        }
        Object bean = this.beanMap.get(beanName);
        Class targetClass = null;
        targetClass = bean != null ? AopProxyUtils.ultimateTargetClass((Object)bean) : beanClass;
        if (!targetClass.isInterface()) {
            Object[] proxyInterceptors;
            if (targetClass.getInterfaces() != null) {
                for (Class<?> targetInterface : targetClass.getInterfaces()) {
                    Object[] proxyInterceptors2 = this.scanAndProxyForTarget(targetInterface, beanName, false);
                    if (proxyInterceptors2 == DO_NOT_PROXY) continue;
                    return proxyInterceptors2;
                }
            }
            if ((proxyInterceptors = this.scanAndProxyForTarget(targetClass, beanName, true)) != DO_NOT_PROXY) {
                return proxyInterceptors;
            }
        }
        return DO_NOT_PROXY;
    }

    protected Object[] scanAndProxyForTarget(Class<?> targetClass, String beanName, boolean proxyTargetClass) {
        String targetClassName = targetClass.getCanonicalName();
        Object[] interceptors = this.getInterceptors(targetClass);
        if (StringUtils.isNotEmpty((String)targetClassName) && !targetClassName.startsWith("java.")) {
            Boolean proxied = this.proxyMap.get(targetClassName);
            if (proxied != null) {
                if (proxied.booleanValue()) {
                    return interceptors;
                }
            } else {
                Object[] proxyInterceptors = null;
                switch (this.proxyMode) {
                    case BY_CLASS_ANNOTATION_ONLY: {
                        proxyInterceptors = this.scanAndProxyForClass(targetClass, targetClassName, beanName, interceptors, proxyTargetClass);
                        break;
                    }
                    case BY_METHOD_ANNOTATION_ONLY: {
                        proxyInterceptors = this.scanAndProxyForMethod(targetClass, targetClassName, beanName, interceptors, proxyTargetClass);
                        break;
                    }
                    case BY_CLASS_OR_METHOD_ANNOTATION: {
                        Object[] classProxyInterceptors = this.scanAndProxyForClass(targetClass, targetClassName, beanName, interceptors, proxyTargetClass);
                        Object[] methodProxyInterceptors = this.scanAndProxyForMethod(targetClass, targetClassName, beanName, interceptors, proxyTargetClass);
                        proxyInterceptors = classProxyInterceptors != DO_NOT_PROXY || methodProxyInterceptors != DO_NOT_PROXY ? interceptors : DO_NOT_PROXY;
                    }
                }
                this.proxyMap.put(targetClassName, proxyInterceptors != DO_NOT_PROXY);
                if (proxyInterceptors != DO_NOT_PROXY) {
                    Object[] commonInterceptorNames;
                    this.proxyTargetClassMap.put(beanName, proxyTargetClass);
                    Logger.info((String)"------------ Proxy Information -----------", (Object[])new Object[0]);
                    Object[] commonInterceptorClasses = this.getCommonInterceptors();
                    if (ArrayUtils.isNotEmpty((Object[])commonInterceptorClasses)) {
                        Logger.info((String)"Class [{}] is proxied by core intercept classes [{}], proxyTargetClass={}", (Object[])new Object[]{targetClassName, StringUtils.toString((Class[])commonInterceptorClasses), proxyTargetClass});
                    }
                    if (ArrayUtils.isNotEmpty((Object[])(commonInterceptorNames = this.getCommonInterceptorNames()))) {
                        Logger.info((String)"Class [{}] is proxied by core intercept beans [{}], proxyTargetClass={}", (Object[])new Object[]{targetClassName, StringUtils.toString((String[])commonInterceptorNames), proxyTargetClass});
                    }
                    if (proxyInterceptors != PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS && ArrayUtils.isNotEmpty((Object[])proxyInterceptors)) {
                        Logger.info((String)"Class [{}] is proxied by additional interceptors [{}], proxyTargetClass={}", (Object[])new Object[]{targetClassName, proxyInterceptors, proxyTargetClass});
                    }
                    Logger.info((String)"-------------------------------------------------", (Object[])new Object[0]);
                }
                return proxyInterceptors;
            }
        }
        return DO_NOT_PROXY;
    }

    protected Object[] scanAndProxyForClass(Class<?> targetClass, String targetClassName, String beanName, Object[] interceptors, boolean proxyTargetClass) {
        boolean proxied = false;
        Object[] classAnnotations = this.getClassAnnotations();
        if (ArrayUtils.isNotEmpty((Object[])classAnnotations)) {
            for (Object classAnnotation : classAnnotations) {
                if (!targetClass.isAnnotationPresent((Class<Annotation>)classAnnotation)) continue;
                if (this.scanMode != ScanMode.FOR_CLASS_ANNOTATION_ONLY && this.scanMode != ScanMode.FOR_CLASS_OR_METHOD_ANNOTATION) {
                    return interceptors;
                }
                this.classAnnotationScanned(targetClass, (Class<? extends Annotation>)classAnnotation);
                if (proxied) continue;
                proxied = true;
            }
        }
        return proxied ? interceptors : DO_NOT_PROXY;
    }

    protected Object[] scanAndProxyForMethod(Class<?> targetClass, String targetClassName, String beanName, Object[] interceptors, boolean proxyTargetClass) {
        boolean proxied = false;
        Object[] methodAnnotations = this.getMethodAnnotations();
        if (ArrayUtils.isNotEmpty((Object[])methodAnnotations)) {
            for (Method method : targetClass.getDeclaredMethods()) {
                for (Object methodAnnotation : methodAnnotations) {
                    if (!method.isAnnotationPresent((Class<? extends Annotation>)methodAnnotation)) continue;
                    if (this.scanMode != ScanMode.FOR_METHOD_ANNOTATION_ONLY && this.scanMode != ScanMode.FOR_CLASS_OR_METHOD_ANNOTATION) {
                        return interceptors;
                    }
                    this.methodAnnotationScanned(targetClass, method, (Class<? extends Annotation>)methodAnnotation);
                    if (proxied) continue;
                    proxied = true;
                }
            }
        }
        return proxied ? interceptors : DO_NOT_PROXY;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Object object = super.postProcessBeforeInitialization(bean, beanName);
        boolean scanPackagesEnabled = this.scanPackagesEnabled();
        if (scanPackagesEnabled) {
            boolean scanPackagesContained = this.scanPackagesContained(bean.getClass());
            if (scanPackagesContained) {
                this.beanMap.put(beanName, bean);
            }
        } else {
            this.beanMap.put(beanName, bean);
        }
        return object;
    }

    protected boolean shouldProxyTargetClass(Class<?> beanClass, String beanName) {
        Boolean proxyTargetClass = this.proxyTargetClassMap.get(beanName);
        if (proxyTargetClass != null) {
            return proxyTargetClass;
        }
        return super.shouldProxyTargetClass(beanClass, beanName);
    }

    protected boolean scanPackagesEnabled() {
        return ArrayUtils.isNotEmpty((Object[])this.scanPackages);
    }

    protected boolean scanPackagesContained(Class<?> beanClass) {
        for (String scanPackage : this.scanPackages) {
            if (!StringUtils.isNotEmpty((String)scanPackage)) continue;
            String beanClassName = beanClass.getCanonicalName();
            if (StringUtils.isNotEmpty((String)beanClassName)) {
                if (!beanClassName.startsWith(scanPackage) && !beanClassName.contains(JDK_PROXY_NAME_KEY) && !beanClassName.contains(CGLIB_PROXY_NAME_KEY)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected Object[] getInterceptors(Class<?> targetClass) {
        Object[] interceptors = this.getAdditionalInterceptors(targetClass);
        if (ArrayUtils.isNotEmpty((Object[])interceptors)) {
            return interceptors;
        }
        Object[] commonInterceptorClasses = this.getCommonInterceptors();
        Object[] commonInterceptorNames = this.getCommonInterceptorNames();
        if (ArrayUtils.isNotEmpty((Object[])commonInterceptorClasses) || ArrayUtils.isNotEmpty((Object[])commonInterceptorNames)) {
            return PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS;
        }
        return DO_NOT_PROXY;
    }

    protected abstract Class<? extends MethodInterceptor>[] getCommonInterceptors();

    protected abstract String[] getCommonInterceptorNames();

    protected abstract MethodInterceptor[] getAdditionalInterceptors(Class<?> var1);

    protected abstract Class<? extends Annotation>[] getClassAnnotations();

    protected abstract Class<? extends Annotation>[] getMethodAnnotations();

    protected abstract void classAnnotationScanned(Class<?> var1, Class<? extends Annotation> var2);

    protected abstract void methodAnnotationScanned(Class<?> var1, Method var2, Class<? extends Annotation> var3);
}

