/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.storage;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.spring.storage.StorageProperties;
import org.aoju.bus.storage.Provider;
import org.aoju.bus.storage.StorageProvider;
import org.aoju.bus.storage.UploadObject;
import org.aoju.bus.storage.UploadToken;
import org.aoju.bus.storage.provider.aliyun.AliyunOSSProvider;
import org.aoju.bus.storage.provider.qiniu.QiniuOSSProvider;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@EnableConfigurationProperties(value={StorageProperties.class})
public class StorageConfiguration
implements InitializingBean,
DisposableBean {
    @Autowired
    StorageProperties properties;
    @Autowired
    StorageProvider storageProvider;

    public void destroy() throws Exception {
        this.storageProvider.close();
    }

    public void afterPropertiesSet() {
        if (Provider.QINIU_OSS.getValue().equals(this.storageProvider)) {
            Assert.notBlank((String)this.properties.accessKey, (String)"[accessKey] not defined", (Object[])new Object[0]);
            Assert.notBlank((String)this.properties.secretKey, (String)"[secretKey] not defined", (Object[])new Object[0]);
            this.storageProvider = new QiniuOSSProvider(this.properties.prefix, this.properties.bucket, this.properties.accessKey, this.properties.secretKey, this.properties.privated);
        } else if (Provider.ALI_OSS.getValue().equals(this.storageProvider)) {
            Assert.notBlank((String)this.properties.endpoint, (String)"[endpoint] not defined", (Object[])new Object[0]);
            this.storageProvider = new AliyunOSSProvider(this.properties.prefix, this.properties.endpoint, this.properties.bucket, this.properties.accessKey, this.properties.secretKey, this.properties.internalUrl, this.properties.privated);
        } else {
            throw new RuntimeException("Provider[" + this.storageProvider + "] not support");
        }
    }

    public String upload(String fileName, File file) {
        return this.storageProvider.upload(new UploadObject(fileName, file));
    }

    public String upload(String fileName, InputStream in, String mimeType) {
        return this.storageProvider.upload(new UploadObject(fileName, in, mimeType));
    }

    public boolean delete(String fileName) {
        return this.storageProvider.delete(fileName);
    }

    public Map<String, Object> createUploadToken(UploadToken param) {
        return this.storageProvider.createUploadToken(param);
    }
}

