/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.oauth;

import org.aoju.bus.logger.Logger;
import org.aoju.bus.oauth.cache.DefaultStateCache;
import org.aoju.bus.oauth.cache.StateCache;
import org.aoju.bus.spring.oauth.AuthProperties;
import org.aoju.bus.spring.oauth.AuthProviderService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={AuthProperties.class})
public class AuthConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="request.oauth", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public AuthProviderService authRequestFactory(AuthProperties properties, StateCache stateCache) {
        return new AuthProviderService(properties, stateCache);
    }

    @ConditionalOnMissingBean(value={StateCache.class})
    @ConditionalOnProperty(name={"request.cache.type"}, havingValue="default", matchIfMissing=true)
    static class Default {
        Default() {
        }

        @Bean
        public StateCache authStateCache() {
            return DefaultStateCache.INSTANCE;
        }

        static {
            Logger.debug((String)"\u4f7f\u7528\u9ed8\u8ba4\u7f13\u5b58\u5b58\u50a8 state \u6570\u636e", (Object[])new Object[0]);
        }
    }
}

