/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.storage;

import org.aoju.bus.spring.storage.StorageProperties;
import org.aoju.bus.spring.storage.StorageProviderService;
import org.aoju.bus.storage.metric.DefaultStorageCache;
import org.aoju.bus.storage.metric.StorageCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={StorageProperties.class})
public class StorageConfiguration {
    @Bean
    public StorageProviderService storageProviderFactory(StorageProperties properties, StorageCache storageCache) {
        return new StorageProviderService(properties, storageCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={StorageCache.class})
    @ConditionalOnProperty(name={"extend.storage.cache.type"}, havingValue="default", matchIfMissing=true)
    public StorageCache storageCache() {
        return DefaultStorageCache.INSTANCE;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StorageConfiguration)) {
            return false;
        }
        StorageConfiguration other = (StorageConfiguration)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof StorageConfiguration;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "StorageConfiguration()";
    }
}

