/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.storage;

import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.spring.storage.StorageProperties;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.Provider;
import org.aoju.bus.storage.Registry;
import org.aoju.bus.storage.metric.StorageCache;
import org.aoju.bus.storage.provider.AliYunOssProvider;
import org.aoju.bus.storage.provider.BaiduYunBosProvider;
import org.aoju.bus.storage.provider.HuaweiObsProvider;
import org.aoju.bus.storage.provider.JdYunOssProvider;
import org.aoju.bus.storage.provider.LocalFileProvider;
import org.aoju.bus.storage.provider.MinioOssProvider;
import org.aoju.bus.storage.provider.QiniuYunOssProvider;
import org.aoju.bus.storage.provider.TencentCosProvider;
import org.aoju.bus.storage.provider.UpaiYunOssProvider;

public class StorageProviderService {
    private final StorageProperties properties;
    private final StorageCache storageCache;

    public Provider get(Registry type) {
        Context context = this.properties.getType().get(1);
        if (Registry.ALIYUN.equals((Object)type)) {
            return new AliYunOssProvider(context);
        }
        if (Registry.BAIDU.equals((Object)type)) {
            return new BaiduYunBosProvider(context);
        }
        if (Registry.HUAWEI.equals((Object)type)) {
            return new HuaweiObsProvider(context);
        }
        if (Registry.JD.equals((Object)type)) {
            return new JdYunOssProvider(context);
        }
        if (Registry.MINIO.equals((Object)type)) {
            return new MinioOssProvider(context);
        }
        if (Registry.QINIU.equals((Object)type)) {
            return new QiniuYunOssProvider(context);
        }
        if (Registry.TENCENT.equals((Object)type)) {
            return new TencentCosProvider(context);
        }
        if (Registry.UPYUN.equals((Object)type)) {
            return new UpaiYunOssProvider(context);
        }
        if (Registry.LOCAL.equals((Object)type)) {
            return new LocalFileProvider(context);
        }
        throw new InstrumentException("-1");
    }

    public StorageProviderService(StorageProperties properties, StorageCache storageCache) {
        this.properties = properties;
        this.storageCache = storageCache;
    }
}

