/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.PackageVersion;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.TimeZone;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.spring.SpringHolder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class SpringBuilder {
    private static ConfigurableApplicationContext context;

    public static ConfigurableApplicationContext getContext() {
        return context;
    }

    public static void setContext(ConfigurableApplicationContext context) {
        Assert.notNull((Object)context, (String)"Could not found context for spring.", (Object[])new Object[0]);
        SpringBuilder.context = context;
        SpringHolder.alive = true;
    }

    public static void refreshContext() {
        if (SpringHolder.alive) {
            context.refresh();
        }
    }

    public static void removeContext() {
        if (SpringHolder.alive) {
            context.close();
            context = null;
            SpringHolder.alive = false;
        }
    }

    public static void register(Class clazz) {
        ConfigurableApplicationContext context = SpringBuilder.getContext();
        if (context != null) {
            DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)context.getBeanFactory();
            String beanName = StringUtils.lowerFirst((CharSequence)clazz.getSimpleName());
            beanFactory.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition((Class)clazz).getBeanDefinition());
        }
    }

    public static void registerSingleton(Class clazz) {
        try {
            SpringBuilder.registerSingleton(clazz, clazz.newInstance());
        }
        catch (InstantiationException e) {
            Logger.error((String)e.getMessage(), (Object[])new Object[]{e});
        }
        catch (IllegalAccessException e) {
            Logger.error((String)e.getMessage(), (Object[])new Object[]{e});
        }
    }

    public static void registerSingleton(Class clazz, Object bean) {
        ConfigurableApplicationContext context = SpringBuilder.getContext();
        if (context != null) {
            DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)context.getBeanFactory();
            String beanName = StringUtils.lowerFirst((CharSequence)clazz.getSimpleName());
            beanFactory.registerSingleton(beanName, bean);
        }
    }

    public static <T> T getBean(Class<T> clazz) {
        ConfigurableApplicationContext context = SpringBuilder.getContext();
        if (context != null) {
            return (T)context.getBean(clazz);
        }
        return null;
    }

    class TimeZoneBuilder {
        @Value(value="${spring.jackson.date-format:yyyy-MM-dd HH:mm:ss}")
        private String pattern;

        TimeZoneBuilder() {
        }

        @Bean
        public Jackson2ObjectMapperBuilderCustomizer customizer() {
            return builder -> {
                builder.locale(Locale.CHINA);
                builder.timeZone(TimeZone.getTimeZone(ZoneId.systemDefault()));
                builder.simpleDateFormat(this.pattern);
                builder.modules(new Module[]{new JavaTimeModule()});
            };
        }

        class JavaTimeModule
        extends SimpleModule {
            JavaTimeModule() {
                super(PackageVersion.VERSION);
                this.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                this.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                this.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
                this.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                this.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                this.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
            }
        }
    }
}

