/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.sensitive;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.sensitive.Provider;
import org.aoju.bus.sensitive.annotation.NShield;
import org.aoju.bus.sensitive.annotation.Privacy;
import org.aoju.bus.sensitive.annotation.Sensitive;
import org.aoju.bus.sensitive.annotation.Shield;
import org.aoju.bus.spring.SpringAware;
import org.aoju.bus.spring.sensitive.SensitiveProperties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class SensitiveStatementHandler
implements Interceptor {
    private static final String MAPPEDSTATEMENT = "delegate.mappedStatement";
    private static final String BOUND_SQL = "delegate.boundSql";

    private static <T> T realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return SensitiveStatementHandler.realTarget(metaObject.getValue("hi.target"));
        }
        return (T)target;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)SensitiveStatementHandler.realTarget(invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue(MAPPEDSTATEMENT);
        SqlCommandType commandType = mappedStatement.getSqlCommandType();
        BoundSql boundSql = (BoundSql)metaObject.getValue(BOUND_SQL);
        Object params = boundSql.getParameterObject();
        if (params instanceof Map) {
            return invocation.proceed();
        }
        SensitiveProperties properties = SpringAware.getBean(SensitiveProperties.class);
        if (ObjectUtils.isNotEmpty((Object[])new Object[]{properties}) && !properties.isDebug()) {
            Sensitive sensitive;
            Sensitive sensitive2 = sensitive = params != null ? params.getClass().getAnnotation(Sensitive.class) : null;
            if (ObjectUtils.isNotEmpty((Object[])new Object[]{sensitive})) {
                this.handleParameters(sensitive, mappedStatement.getConfiguration(), boundSql, params, commandType);
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object o) {
        return Plugin.wrap((Object)o, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private void handleParameters(Sensitive sensitive, Configuration configuration, BoundSql boundSql, Object param, SqlCommandType commandType) {
        HashMap<String, Object> newValues = new HashMap<String, Object>(16);
        MetaObject metaObject = configuration.newMetaObject(param);
        for (Field field : param.getClass().getDeclaredFields()) {
            Privacy privacy;
            Object value = metaObject.getValue(field.getName());
            if (value instanceof CharSequence && this.isWriteCommand(commandType) && !Provider.alreadyBeSentisived((Object)value) && ("ALL".equals(sensitive.value()) || "SENS".equals(sensitive.value()) && ("ALL".equals(sensitive.stage()) || "IN".equals(sensitive.stage())))) {
                value = this.handleSensitive(field, value);
            }
            if (!ObjectUtils.isNotEmpty((Object[])new Object[]{value})) continue;
            if (("ALL".equals(sensitive.value()) || "SAFE".equals(sensitive.value()) && ("ALL".equals(sensitive.stage()) || "IN".equals(sensitive.stage()))) && ObjectUtils.isNotEmpty((Object[])new Object[]{privacy = field.getAnnotation(Privacy.class)}) && StringUtils.isNotEmpty((String)privacy.value()) && ("ALL".equals(privacy.value()) || "IN".equals(privacy.value()))) {
                SensitiveProperties properties = SpringAware.getBean(SensitiveProperties.class);
                if (ObjectUtils.isEmpty((Object[])new Object[]{properties})) {
                    throw new InstrumentException("please check the request.crypto.encrypt");
                }
                value = Builder.encrypt((String)properties.getEncrypt().getType(), (String)properties.getEncrypt().getKey(), (String)value.toString(), (java.nio.charset.Charset)Charset.UTF_8);
            }
            newValues.put(field.getName(), value);
        }
        for (Map.Entry entry : newValues.entrySet()) {
            boundSql.setAdditionalParameter((String)entry.getKey(), entry.getValue());
        }
    }

    private boolean isWriteCommand(SqlCommandType commandType) {
        return SqlCommandType.UPDATE.equals((Object)commandType) || SqlCommandType.INSERT.equals((Object)commandType);
    }

    private Object handleSensitive(Field field, Object value) {
        NShield json;
        Shield sensitiveField = field.getAnnotation(Shield.class);
        if (ObjectUtils.isNotEmpty((Object[])new Object[]{sensitiveField})) {
            org.aoju.bus.sensitive.Builder.on((Object)value);
        }
        if (ObjectUtils.isNotEmpty((Object[])new Object[]{json = field.getAnnotation(NShield.class)}) && ObjectUtils.isNotEmpty((Object[])new Object[]{value})) {
            Shield[] keys;
            Map map = Provider.parseToObjectMap((String)value.toString());
            for (Shield f : keys = json.value()) {
                String key = f.key();
                Object data = map.get(key);
                if (data == null) continue;
                map.put(key, org.aoju.bus.sensitive.Builder.on(data));
            }
            value = Provider.parseMaptoJSONString((Map)map);
        }
        return value;
    }
}

