/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.StreamSupport;
import org.aoju.bus.core.utils.StringUtils;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.ClassUtils;

public class BusListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final MapPropertySource HIGH_PRIORITY_CONFIG = new MapPropertySource("BusHighPriorityConfig", new HashMap());
    private static AtomicBoolean executed = new AtomicBoolean(false);

    public static boolean filterAllLogConfig(String key) {
        return key.startsWith("logging.level.") || key.startsWith("logging.path.") || key.startsWith("logging.config.") || key.equals("logging.path") || key.equals("loggingRoot") || key.equals("file.encoding");
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        SpringApplication application = event.getSpringApplication();
        if (executed.compareAndSet(false, true)) {
            StandardEnvironment bootstrapEnvironment = new StandardEnvironment();
            StreamSupport.stream(environment.getPropertySources().spliterator(), false).filter(source -> !(source instanceof PropertySource.StubPropertySource)).forEach(source -> bootstrapEnvironment.getPropertySources().addLast(source));
            ArrayList<Class> sources = new ArrayList<Class>();
            for (Object s : application.getAllSources()) {
                if (s instanceof Class) {
                    sources.add((Class)s);
                    continue;
                }
                if (!(s instanceof String)) continue;
                sources.add(ClassUtils.resolveClassName((String)((String)s), null));
            }
            SpringApplication bootstrapApplication = new SpringApplicationBuilder(new Class[0]).profiles(environment.getActiveProfiles()).bannerMode(Banner.Mode.OFF).environment((ConfigurableEnvironment)bootstrapEnvironment).sources(sources.toArray(new Class[0])).registerShutdownHook(false).logStartupInfo(false).web(WebApplicationType.NONE).listeners(new ApplicationListener[0]).initializers(new ApplicationContextInitializer[0]).build(event.getArgs());
            ApplicationEnvironmentPreparedEvent bootstrapEvent = new ApplicationEnvironmentPreparedEvent(bootstrapApplication, event.getArgs(), (ConfigurableEnvironment)bootstrapEnvironment);
            application.getListeners().stream().filter(listener -> listener instanceof ConfigFileApplicationListener).forEach(listener -> ((ConfigFileApplicationListener)listener).onApplicationEvent((ApplicationEvent)bootstrapEvent));
            this.assemblyLogSetting((ConfigurableEnvironment)bootstrapEnvironment);
            this.assemblyRequireProperties((ConfigurableEnvironment)bootstrapEnvironment);
            this.assemblyEnvironmentMark(environment);
        } else {
            this.unAssemblyEnvironmentMark(environment);
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private void assemblyLogSetting(ConfigurableEnvironment environment) {
        StreamSupport.stream(environment.getPropertySources().spliterator(), false).filter(propertySource -> propertySource instanceof EnumerablePropertySource).map(propertySource -> Arrays.asList(((EnumerablePropertySource)propertySource).getPropertyNames())).flatMap(Collection::stream).filter(BusListener::filterAllLogConfig).forEach(key -> ((Map)HIGH_PRIORITY_CONFIG.getSource()).put(key, environment.getProperty(key)));
    }

    private void assemblyRequireProperties(ConfigurableEnvironment environment) {
        if (StringUtils.hasText((String)environment.getProperty("spring.application.name"))) {
            ((Map)HIGH_PRIORITY_CONFIG.getSource()).put("spring.application.name", environment.getProperty("spring.application.name"));
        }
    }

    private void assemblyEnvironmentMark(ConfigurableEnvironment environment) {
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("BusBootstrap", new HashMap()));
    }

    private void unAssemblyEnvironmentMark(ConfigurableEnvironment environment) {
        environment.getPropertySources().remove("BusBootstrap");
    }
}

