/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.wrapper;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aoju.bus.core.utils.EscapeUtils;
import org.aoju.bus.core.utils.MapUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.starter.wrapper.CacheRequestWrapper;
import org.aoju.bus.starter.wrapper.CacheResponseWrapper;
import org.aoju.bus.starter.wrapper.WrapperProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@EnableConfigurationProperties(value={WrapperProperties.class})
public class WrapperConfiguration {
    @Autowired
    WrapperProperties properties;

    @Bean(value={"registrationBodyCacheFilter"})
    public FilterRegistrationBean registrationBodyCacheFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setEnabled(this.properties.getEnabled().booleanValue());
        registrationBean.setOrder(this.properties.getOrder());
        registrationBean.setFilter((Filter)new BodyCacheFilter());
        if (!StringUtils.isEmpty((Object)this.properties.getName())) {
            registrationBean.setName(this.properties.getName());
        }
        if (MapUtils.isNotEmpty(this.properties.getInitParameters())) {
            registrationBean.setInitParameters(this.properties.getInitParameters());
        }
        if (ObjectUtils.isNotEmpty((Object[])new Object[]{this.properties.getServletRegistrationBeans()})) {
            registrationBean.setServletRegistrationBeans(this.properties.getServletRegistrationBeans());
        }
        if (!CollectionUtils.isEmpty(this.properties.getServletNames())) {
            registrationBean.setServletNames(this.properties.getServletNames());
        }
        return registrationBean;
    }

    @Bean
    public ObjectMapper objectMapper(Jackson2ObjectMapperBuilder builder) {
        ObjectMapper objectMapper = builder.createXmlMapper(false).build();
        SimpleModule simpleModule = new SimpleModule("commonJsonSerializer");
        simpleModule.addSerializer((JsonSerializer)new CommonJsonSerializer(this.properties));
        objectMapper.registerModule((Module)simpleModule);
        return objectMapper;
    }

    private static class BodyCacheFilter
    extends OncePerRequestFilter {
        private BodyCacheFilter() {
        }

        protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
            String method = request.getMethod();
            if (("POST".equals(method) || "PATCH".equals(method) || "PUT".equals(method)) && !(request instanceof CacheRequestWrapper)) {
                request = new CacheRequestWrapper((HttpServletRequest)request);
            }
            if (!(response instanceof CacheResponseWrapper)) {
                response = new CacheResponseWrapper((HttpServletResponse)response);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    static class CommonJsonSerializer
    extends JsonSerializer<String> {
        private WrapperProperties properties;

        CommonJsonSerializer(WrapperProperties properties) {
            this.properties = properties;
        }

        public Class<String> handledType() {
            return String.class;
        }

        public void serialize(String value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (value != null && this.properties != null) {
                value = EscapeUtils.escapeHtml4((String)value);
                jsonGenerator.writeString(value);
            }
        }
    }
}

