/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.druid;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Map;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.starter.druid.DataSource;
import org.aoju.bus.starter.druid.DynamicDataSource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

public class DataSourceHolder {
    private static final ThreadLocal<String> DATA_SOURCE_KEY = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return "dataSource";
        }
    };

    public static void setKey(String key) {
        DATA_SOURCE_KEY.set(key);
    }

    public static String getKey() {
        return DATA_SOURCE_KEY.get();
    }

    public static void remove() {
        DATA_SOURCE_KEY.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addDataSource(Map<String, String> map) {
        try {
            Connection connection = null;
            try {
                Class.forName(map.get("driverClassName"));
                connection = DriverManager.getConnection(map.get("url"), map.get("username"), map.get("password"));
                System.out.println(connection.isClosed());
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            String key = map.get("key");
            if (StringUtils.isBlank((CharSequence)key)) {
                return false;
            }
            if (DynamicDataSource.getInstance().containsKey(key)) {
                return true;
            }
            DruidDataSource druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource(map);
            druidDataSource.init();
            DynamicDataSource.addDataSource(key, (javax.sql.DataSource)druidDataSource);
            return true;
        }
        catch (Exception e) {
            Logger.error((String)e.getMessage(), (Object[])new Object[0]);
            return false;
        }
    }

    @Order(value=-1)
    @Aspect
    @Component
    public class DataSourceSwitch {
        @Pointcut(value="@annotation(org.aoju.bus.starter.druid.DataSource)")
        public void switching() {
        }

        @Around(value="switching()")
        public Object around(ProceedingJoinPoint point) throws Throwable {
            Method method = ((MethodSignature)point.getSignature()).getMethod();
            DataSource dataSource = method.getAnnotation(DataSource.class);
            if (!StringUtils.hasLength((String)dataSource.value())) {
                dataSource = method.getDeclaringClass().getAnnotation(DataSource.class);
            }
            if (null != dataSource) {
                DataSourceHolder.setKey(dataSource.value());
                Logger.info((String)"Switch datasource to [{}] in method [{}]", (Object[])new Object[]{DataSourceHolder.getKey(), point.getSignature()});
            }
            Object object = point.proceed();
            DataSourceHolder.remove();
            Logger.info((String)"Restore datasource to [{}] in method [{}]", (Object[])new Object[]{DataSourceHolder.getKey(), point.getSignature()});
            return object;
        }
    }
}

