/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.druid;

import com.alibaba.druid.pool.DruidDataSource;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.starter.druid.AspectjDruidProxy;
import org.aoju.bus.starter.druid.DruidProperties;
import org.aoju.bus.starter.druid.DynamicDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@ConditionalOnClass(value={DruidDataSource.class})
@EnableConfigurationProperties(value={DruidProperties.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@Import(value={AspectjDruidProxy.class})
public class DruidConfiguration {
    private static final ConfigurationPropertyNameAliases aliases = new ConfigurationPropertyNameAliases();
    @Autowired
    DruidProperties druidProperties;
    private Map<Object, Object> sourceMap = new HashMap<Object, Object>();

    @Bean
    @Primary
    public DynamicDataSource dataSource() {
        Map<String, Object> defaultConfig = this.beanToMap(this.druidProperties);
        DataSource defaultDatasource = this.bind(defaultConfig);
        this.sourceMap.put("dataSource", defaultDatasource);
        if (ObjectUtils.isNotEmpty((Object[])new Object[]{this.druidProperties.getMulti()})) {
            Logger.info((String)"Enabled Multiple DataSource", (Object[])new Object[0]);
            List<DruidProperties> list = this.druidProperties.getMulti();
            for (int i = 0; i < list.size(); ++i) {
                Map<String, Object> config = this.beanToMap(list.get(i));
                if (((Boolean)config.getOrDefault("extend", Boolean.TRUE)).booleanValue()) {
                    HashMap<String, Object> properties = new HashMap<String, Object>(defaultConfig);
                    properties.putAll(config);
                }
                this.sourceMap.put(config.get("key").toString(), this.bind(config));
            }
        }
        DynamicDataSource dataSource = new DynamicDataSource();
        dataSource.setDefaultTargetDataSource(defaultDatasource);
        dataSource.setTargetDataSources(this.sourceMap);
        return dataSource;
    }

    @Bean
    public DataSourceTransactionManager transactionManager(DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    private DataSource bind(Map<String, Object> map) {
        String type = StringUtils.toString((Object)map.get("type"));
        if (StringUtils.isEmpty((CharSequence)type)) {
            throw new InstrumentException("The database type is empty");
        }
        try {
            return this.bind(Class.forName(type), map);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot resolve class with type: " + type);
        }
    }

    private <T> Map<String, Object> beanToMap(T bean) {
        HashMap map = Maps.newHashMap();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                Object value = beanMap.get(key);
                if (StringUtils.isNotEmpty((CharSequence)this.druidProperties.getPrivateKey())) {
                    Logger.info((String)"The database connection is securely enabled", (Object[])new Object[0]);
                    if ("url".equals(key)) {
                        value = Builder.decrypt((String)"AES", (String)this.druidProperties.getPrivateKey(), (String)value.toString(), (java.nio.charset.Charset)Charset.UTF_8);
                        beanMap.put((Object)"url", value);
                    } else if ("username".equals(key)) {
                        value = Builder.decrypt((String)"AES", (String)this.druidProperties.getPrivateKey(), (String)value.toString(), (java.nio.charset.Charset)Charset.UTF_8);
                        beanMap.put((Object)"username", value);
                    } else if ("password".equals(key)) {
                        value = Builder.decrypt((String)"AES", (String)this.druidProperties.getPrivateKey(), (String)value.toString(), (java.nio.charset.Charset)Charset.UTF_8);
                        beanMap.put((Object)"password", value);
                    }
                }
                map.put(StringUtils.toString(key), value);
            }
        }
        return map;
    }

    private void bind(DataSource result, Map properties) {
        MapConfigurationPropertySource source = new MapConfigurationPropertySource(properties);
        Binder binder = new Binder(new ConfigurationPropertySource[]{source.withAliases(aliases)});
        binder.bind(ConfigurationPropertyName.EMPTY, Bindable.ofInstance((Object)result));
    }

    private <T extends DataSource> T bind(Class<T> clazz, Map properties) {
        MapConfigurationPropertySource source = new MapConfigurationPropertySource(properties);
        Binder binder = new Binder(new ConfigurationPropertySource[]{source.withAliases(aliases)});
        return (T)((DataSource)binder.bind(ConfigurationPropertyName.EMPTY, Bindable.of(clazz)).get());
    }

    static {
        aliases.addAliases("url", new String[]{"jdbc-url"});
        aliases.addAliases("username", new String[]{"user"});
    }
}

