/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.notify;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.notify.Provider;
import org.aoju.bus.notify.Registry;
import org.aoju.bus.notify.metric.Properties;
import org.aoju.bus.notify.provider.aliyun.AliyunSmsProperties;
import org.aoju.bus.notify.provider.aliyun.AliyunSmsProvider;
import org.aoju.bus.notify.provider.aliyun.AliyunVmsProperties;
import org.aoju.bus.notify.provider.aliyun.AliyunVmsProvider;
import org.aoju.bus.notify.provider.dingtalk.DingTalkCropMsgProvider;
import org.aoju.bus.notify.provider.dingtalk.DingTalkProperties;
import org.aoju.bus.notify.provider.netease.NeteaseAttachMsgProvider;
import org.aoju.bus.notify.provider.netease.NeteaseMsgProvider;
import org.aoju.bus.notify.provider.netease.NeteaseProperties;
import org.aoju.bus.starter.notify.NotifyProperties;

public class NotifyProviderService {
    public final NotifyProperties properties;
    private static Map<Registry, Properties> NOTIFY_CACHE = new ConcurrentHashMap<Registry, Properties>();

    public static void register(Registry registry, Properties properties) {
        if (NOTIFY_CACHE.containsKey(registry)) {
            throw new InstrumentException("\u91cd\u590d\u6ce8\u518c\u540c\u540d\u79f0\u7684\u7ec4\u4ef6\uff1a" + registry.name());
        }
        NOTIFY_CACHE.putIfAbsent(registry, properties);
    }

    public static Provider get(Registry registry) {
        if (Registry.ALIYUN_SMS.equals((Object)registry)) {
            return new AliyunSmsProvider((AliyunSmsProperties)NOTIFY_CACHE.get(registry));
        }
        if (Registry.ALIYUN_VMS.equals((Object)registry)) {
            return new AliyunVmsProvider((AliyunVmsProperties)NOTIFY_CACHE.get(registry));
        }
        if (Registry.DINGTALK_CORP_MSG.equals((Object)registry)) {
            return new DingTalkCropMsgProvider((DingTalkProperties)NOTIFY_CACHE.get(registry));
        }
        if (Registry.NETEASE_ATTACH_MSG.equals((Object)registry)) {
            return new NeteaseAttachMsgProvider((NeteaseProperties)NOTIFY_CACHE.get(registry));
        }
        if (Registry.NETEASE_MSG.equals((Object)registry)) {
            return new NeteaseMsgProvider((NeteaseProperties)NOTIFY_CACHE.get(registry));
        }
        return null;
    }

    public NotifyProviderService(NotifyProperties properties) {
        this.properties = properties;
    }
}

