/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.mapper;

import java.io.FileNotFoundException;
import javax.sql.DataSource;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.starter.mapper.MybatisPluginBuilder;
import org.aoju.bus.starter.mapper.MybatisProperties;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@EnableConfigurationProperties(value={MybatisProperties.class})
public class MybatisConfiguration {
    @Autowired
    MybatisProperties properties;

    @Bean
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource) {
        try {
            SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
            bean.setDataSource(dataSource);
            if (StringKit.isNotBlank((CharSequence)this.properties.getTypeAliasesPackage())) {
                bean.setTypeAliasesPackage(this.properties.getTypeAliasesPackage());
            }
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            bean.setPlugins(MybatisPluginBuilder.build(this.properties));
            try {
                bean.setMapperLocations(resolver.getResources(this.properties.getXmlLocation()));
            }
            catch (FileNotFoundException e) {
                Logger.warn((String)e.getMessage(), (Object[])new Object[0]);
            }
            return bean.getObject();
        }
        catch (Exception e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    @Bean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

