/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.socket;

import org.aoju.bus.socket.netty.CustomizeEventHandler;
import org.aoju.bus.socket.netty.EventHandler;
import org.aoju.bus.socket.netty.SocketService;
import org.aoju.bus.socket.netty.annotation.WebSocket;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class SocketHandlerBeanPostProcessor
implements BeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class clazz = AopUtils.getTargetClass((Object)bean);
        WebSocket annotation = clazz.getAnnotation(WebSocket.class);
        if (annotation != null) {
            if (EventHandler.class.isAssignableFrom(clazz)) {
                SocketService.addHandler((String)annotation.value(), (EventHandler)((EventHandler)bean));
            } else if (CustomizeEventHandler.class.isAssignableFrom(clazz)) {
                SocketService.addCustomizeHandler((CustomizeEventHandler)((CustomizeEventHandler)bean));
            }
        }
        return bean;
    }
}

