/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.swagger;

import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import org.aoju.bus.core.key.ObjectID;
import org.aoju.bus.starter.swagger.SwaggerProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

@EnableConfigurationProperties(value={SwaggerProperties.class})
public class SwaggerConfiguration
implements WebMvcConfigurer {
    @Autowired
    SwaggerProperties properties;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    @Bean
    public Docket createRestApi() {
        RequestParameterBuilder aParameterBuilder = new RequestParameterBuilder();
        aParameterBuilder.in("header").name("X-Access-Token").description("X-Access-Token\u683c\u5f0f\u4e3a:" + ObjectID.id()).required(Boolean.valueOf(false)).build();
        ArrayList<RequestParameter> requestParameters = new ArrayList<RequestParameter>();
        requestParameters.add(aParameterBuilder.build());
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).paths(PathSelectors.any()).build().globalRequestParameters(requestParameters);
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.properties.getTitle()).description(this.properties.getDescription()).license(this.properties.getLicense()).licenseUrl(this.properties.getLicenseUrl()).termsOfServiceUrl(this.properties.getTermsOfServiceUrl()).contact(new Contact(this.properties.getContact().getName(), this.properties.getContact().getUrl(), this.properties.getContact().getEmail())).version(this.properties.getVersion()).build();
    }
}

