/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.goalie;

import java.util.List;
import java.util.function.BiFunction;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.goalie.reactor.AssetRegistry;
import org.aoju.bus.goalie.reactor.Athlete;
import org.aoju.bus.goalie.reactor.GlobalExceptionHandler;
import org.aoju.bus.goalie.reactor.RouterHandler;
import org.aoju.bus.starter.goalie.GoalieProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.server.WebExceptionHandler;
import org.springframework.web.server.WebFilter;
import reactor.netty.http.server.HttpServer;

@ConditionalOnWebApplication
@EnableConfigurationProperties(value={GoalieProperties.class})
public class ReactorConfiguration {
    @Autowired
    GoalieProperties goalieProperties;
    @Autowired(required=false)
    List<AssetRegistry> assetRegistries;
    @Autowired(required=false)
    List<WebExceptionHandler> webExceptionHandlers;
    @Autowired(required=false)
    List<WebFilter> webFilters;

    @Bean
    WebExceptionHandler webExceptionHandler() {
        return new GlobalExceptionHandler();
    }

    @Bean(initMethod="init", destroyMethod="destroy")
    Athlete athlete() {
        RouterHandler routerHandler = new RouterHandler();
        RouterFunction routerFunction = RouterFunctions.route((RequestPredicate)RequestPredicates.path((String)this.goalieProperties.getServer().getPath()).and(RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.APPLICATION_FORM_URLENCODED})), arg_0 -> ((RouterHandler)routerHandler).handle(arg_0));
        HandlerStrategies.Builder builder = HandlerStrategies.builder();
        if (CollKit.isNotEmpty(this.webExceptionHandlers)) {
            AnnotationAwareOrderComparator.sort(this.webExceptionHandlers);
            this.webExceptionHandlers.forEach(arg_0 -> ((HandlerStrategies.Builder)builder).exceptionHandler(arg_0));
        }
        if (CollKit.isNotEmpty(this.webFilters)) {
            AnnotationAwareOrderComparator.sort(this.webFilters);
            this.webFilters.forEach(arg_0 -> ((HandlerStrategies.Builder)builder).webFilter(arg_0));
        }
        HandlerStrategies handlerStrategies = builder.build();
        HttpHandler handler = RouterFunctions.toHttpHandler((RouterFunction)routerFunction, (HandlerStrategies)handlerStrategies);
        ReactorHttpHandlerAdapter adapter = new ReactorHttpHandlerAdapter(handler);
        HttpServer server = HttpServer.create().port(this.goalieProperties.getServer().getPort()).handle((BiFunction)adapter);
        return new Athlete(server, this.assetRegistries);
    }
}

