/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.goalie.filter;

import java.util.Map;
import org.aoju.bus.base.consts.ErrorCode;
import org.aoju.bus.base.entity.OAuth2;
import org.aoju.bus.core.lang.exception.BusinessException;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.goalie.reactor.Asset;
import org.aoju.bus.goalie.reactor.ExchangeContext;
import org.aoju.bus.goalie.reactor.login.AuthProvider;
import org.aoju.bus.goalie.reactor.login.LoginResponse;
import org.aoju.bus.starter.goalie.ReactorConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
@ConditionalOnBean(value={ReactorConfiguration.class})
@Order(value=-2147483644)
public class AuthFilter
implements WebFilter {
    @Autowired
    AuthProvider provider;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ExchangeContext context = ExchangeContext.get((ServerWebExchange)exchange);
        Asset asset = context.getAsset();
        Map requestMap = context.getRequestMap();
        if (asset.isToken()) {
            String token = exchange.getRequest().getHeaders().getFirst("X-Access-Token");
            LoginResponse response = this.provider.authorize(token);
            if (response.isOk()) {
                OAuth2 auth2 = response.getOAuth2();
                Map map = BeanKit.beanToMap((Object)auth2, (boolean)false, (boolean)true);
                map.forEach((k, v) -> requestMap.put(k, v.toString()));
            } else {
                throw new BusinessException(ErrorCode.EM_FAILURE, response.getMessage().errmsg);
            }
        }
        return chain.filter(exchange);
    }
}

