/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.goalie.filter;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aoju.bus.base.consts.ErrorCode;
import org.aoju.bus.core.lang.exception.BusinessException;
import org.aoju.bus.goalie.reactor.Asset;
import org.aoju.bus.goalie.reactor.Athlete;
import org.aoju.bus.goalie.reactor.ExchangeContext;
import org.aoju.bus.starter.goalie.ReactorConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
@ConditionalOnBean(value={ReactorConfiguration.class})
@Order(value=-2147483645)
public class PermissionFilter
implements WebFilter {
    @Autowired
    Athlete athlete;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ExchangeContext context = ExchangeContext.get((ServerWebExchange)exchange);
        Map params = context.getRequestMap();
        String method = (String)params.get("method");
        String version = (String)params.get("v");
        Set assets = this.athlete.getAssets();
        List assetsList = assets.parallelStream().filter(asset -> Objects.equals(method, asset.getMethod())).collect(Collectors.toList());
        if (assetsList.size() < 1) {
            return Mono.error((Throwable)new BusinessException(ErrorCode.EM_100103));
        }
        Asset asset2 = assetsList.parallelStream().filter(c -> Objects.equals(version, c.getVersion())).findFirst().orElseThrow(() -> new BusinessException(ErrorCode.EM_100102));
        context.setAsset(asset2);
        return chain.filter(exchange);
    }
}

